/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.sink.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;

public abstract class AbstractBinarySinkFactory
implements SinkFactory {
    public Sink createSink(File outputDir, String outputName) throws IOException {
        return this.createSink(outputDir, outputName, "UTF-8");
    }

    public Sink createSink(File outputDir, String outputName, String encoding) throws IOException {
        if (outputDir == null) {
            throw new IllegalArgumentException("outputDir cannot be null.");
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        } else if (!outputDir.isDirectory()) {
            throw new IllegalArgumentException("The dir '" + outputDir + "' is not a directory.");
        }
        FileOutputStream out = new FileOutputStream(new File(outputDir, outputName));
        return this.createSink(out, encoding);
    }

    public Sink createSink(OutputStream out) throws IOException {
        return this.createSink(out, "UTF-8");
    }
}

