/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.array.TestArrayNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.objects.JSObject;

@ReportPolymorphism
public abstract class TestArrayNode
extends JavaScriptBaseNode {
    protected static final int MAX_TYPE_COUNT = 4;
    protected final Test test;

    protected TestArrayNode(Test test) {
        this.test = test;
    }

    protected static ScriptArray getArrayType(DynamicObject target, boolean condition) {
        return JSObject.getArray(target, condition);
    }

    protected static TestArrayNode create(Test test) {
        return TestArrayNodeGen.create(test);
    }

    public static TestArrayNode createHasHoles() {
        return TestArrayNode.create(Test.HasHoles);
    }

    public abstract boolean executeBoolean(DynamicObject var1, boolean var2);

    @Specialization(guards={"arrayType.isInstance(getArrayType(target, condition))", "arrayType.isStatelessType()"}, limit="MAX_TYPE_COUNT")
    protected final boolean doCached(DynamicObject target, boolean condition, @Cached(value="getArrayType(target, condition)") ScriptArray arrayType) {
        if (this.test == Test.HasHoles) {
            return arrayType.hasHoles(target, condition);
        }
        throw Errors.shouldNotReachHere();
    }

    @Specialization(replaces={"doCached"})
    protected final boolean doUncached(DynamicObject target, boolean condition) {
        ScriptArray arrayType = TestArrayNode.getArrayType(target, condition);
        return this.doCached(target, condition, arrayType);
    }

    protected static enum Test {
        HasHoles;

    }
}

