/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.unary.JSIsArrayNodeGen;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSClass;

public abstract class JSIsArrayNode
extends JavaScriptBaseNode {
    protected static final int MAX_SHAPE_COUNT = 1;
    protected static final int MAX_JSCLASS_COUNT = 1;
    final boolean jsType;

    protected JSIsArrayNode(boolean jsType) {
        this.jsType = jsType;
    }

    public abstract boolean execute(Object var1);

    @Specialization(guards={"cachedIsJSObject", "!cachedIsProxy", "cachedShape.check(object)"}, limit="MAX_SHAPE_COUNT")
    protected static boolean doIsArrayShape(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="isJSObject(object)") boolean cachedIsJSObject, @Cached(value="isJSArray(object)") boolean cachedIsArray, @Cached(value="isJSProxy(object)") boolean cachedIsProxy) {
        return cachedIsArray && cachedShape.check(object);
    }

    @Specialization(guards={"!cachedIsProxy", "cachedClass != null", "cachedClass.isInstance(object)"}, replaces={"doIsArrayShape"}, limit="MAX_JSCLASS_COUNT")
    protected static boolean doIsArrayJSClass(DynamicObject object, @Cached(value="getJSClassChecked(object)") JSClass cachedClass, @Cached(value="isJSArray(object)") boolean cachedIsArray, @Cached(value="isJSProxy(object)") boolean cachedIsProxy) {
        return cachedIsArray;
    }

    @Specialization(guards={"isJSArray(object)"}, replaces={"doIsArrayJSClass"})
    protected boolean doJSArray(DynamicObject object) {
        return true;
    }

    @Specialization(guards={"isJSProxy(object)"})
    protected boolean doJSProxy(DynamicObject object) {
        return JSRuntime.isArray(object);
    }

    @Specialization(guards={"isJSType(object)", "!isJSArray(object)", "!isJSProxy(object)"}, replaces={"doIsArrayJSClass"})
    protected boolean doJSObject(DynamicObject object) {
        assert (!JSRuntime.isArray(object));
        return false;
    }

    @Specialization(guards={"!isJSType(object)", "jsType"})
    protected boolean doNotObject(Object object) {
        assert (!JSRuntime.isArray(object) || JSRuntime.isForeignObject(object));
        return false;
    }

    @Specialization(guards={"!isJSType(object)", "!jsType"})
    protected boolean doForeign(Object object, @CachedLibrary(limit="3") InteropLibrary interop) {
        return interop.hasArrayElements(object);
    }

    public static JSIsArrayNode createIsArrayLike() {
        return JSIsArrayNodeGen.create(false);
    }

    public static JSIsArrayNode createIsArray() {
        return JSIsArrayNodeGen.create(true);
    }
}

