/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.object.LocationImpl;
import com.oracle.truffle.object.ShapeImpl;
import java.util.Objects;

public class PropertyImpl
extends Property {
    private final Object key;
    private final Location location;
    private final int flags;
    private final boolean relocatable;

    PropertyImpl(Object key, Location location, int flags, boolean relocatable) {
        this.key = Objects.requireNonNull(key);
        this.location = Objects.requireNonNull(location);
        this.flags = flags;
        this.relocatable = relocatable;
    }

    public PropertyImpl(Object name, Location location, int flags) {
        this(name, location, flags, true);
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public Property relocate(Location newLocation) {
        if (!this.getLocation().equals(newLocation) && this.relocatable) {
            return this.construct(this.key, newLocation, this.flags);
        }
        return this;
    }

    @Override
    public final Object get(DynamicObject store, Shape shape) {
        return this.getLocation().get(store, shape);
    }

    @Override
    public final Object get(DynamicObject store, boolean condition) {
        return this.getLocation().get(store, condition);
    }

    @Override
    public final void setInternal(DynamicObject store, Object value) {
        try {
            ((LocationImpl)this.getLocation()).setInternal(store, value);
        }
        catch (IncompatibleLocationException e) {
            throw new IllegalStateException();
        }
    }

    private static boolean verifyShapeParameter(DynamicObject store, Shape shape) {
        assert (shape == null || store.getShape() == shape) : "wrong shape";
        return true;
    }

    @Override
    public final void set(DynamicObject store, Object value, Shape shape) throws IncompatibleLocationException, FinalLocationException {
        assert (PropertyImpl.verifyShapeParameter(store, shape));
        this.getLocation().set(store, value, shape);
    }

    @Override
    public final void setSafe(DynamicObject store, Object value, Shape shape) {
        assert (PropertyImpl.verifyShapeParameter(store, shape));
        try {
            this.getLocation().set(store, value, shape);
        }
        catch (FinalLocationException | IncompatibleLocationException ex) {
            throw new IllegalStateException();
        }
    }

    @Override
    public final void setGeneric(DynamicObject store, Object value, Shape shape) {
        assert (PropertyImpl.verifyShapeParameter(store, shape));
        try {
            this.set(store, value, shape);
        }
        catch (FinalLocationException | IncompatibleLocationException ex) {
            this.setSlowCase(store, value);
        }
    }

    private static boolean verifyShapeParameters(DynamicObject store, Shape oldShape, Shape newShape) {
        assert (store.getShape() == oldShape) : "wrong shape";
        assert (newShape.isValid()) : "invalid shape";
        return true;
    }

    @Override
    public final void set(DynamicObject store, Object value, Shape oldShape, Shape newShape) throws IncompatibleLocationException {
        assert (PropertyImpl.verifyShapeParameters(store, oldShape, newShape));
        this.getLocation().set(store, value, oldShape, newShape);
    }

    @Override
    public final void setSafe(DynamicObject store, Object value, Shape oldShape, Shape newShape) {
        assert (PropertyImpl.verifyShapeParameters(store, oldShape, newShape));
        try {
            this.getLocation().set(store, value, oldShape, newShape);
        }
        catch (IncompatibleLocationException ex) {
            throw new IllegalStateException();
        }
    }

    @Override
    public final void setGeneric(DynamicObject store, Object value, Shape oldShape, Shape newShape) {
        assert (PropertyImpl.verifyShapeParameters(store, oldShape, newShape));
        try {
            this.getLocation().set(store, value, oldShape, newShape);
        }
        catch (IncompatibleLocationException ex) {
            this.setWithShapeSlowCase(store, value, oldShape, newShape);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        return this.key.equals(other.key) && this.flags == other.flags && this.relocatable == other.relocatable && this.location.equals(other.location);
    }

    @Override
    public boolean isSame(Property obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        return this.key.equals(other.key) && this.flags == other.flags;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.location.hashCode();
        result = 31 * result + this.flags;
        return result;
    }

    public String toString() {
        return "\"" + this.key + "\":" + this.location + (this.flags == 0 ? "" : "%" + this.flags);
    }

    @Override
    public final Location getLocation() {
        return this.location;
    }

    private void setSlowCase(DynamicObject store, Object value) {
        ShapeImpl oldShape = (ShapeImpl)store.getShape();
        oldShape.getLayout().getStrategy().propertySetFallback(this, store, value, oldShape);
    }

    private void setWithShapeSlowCase(DynamicObject store, Object value, Shape currentShape, Shape nextShape) {
        ShapeImpl oldShape = (ShapeImpl)currentShape;
        oldShape.getLayout().getStrategy().propertySetWithShapeFallback(this, store, value, oldShape, (ShapeImpl)nextShape);
    }

    @Override
    public final boolean isHidden() {
        return this.key instanceof HiddenKey;
    }

    protected Property construct(Object name, Location location, int flags) {
        return new PropertyImpl(name, location, flags, this.relocatable);
    }

    @Override
    public Property copyWithFlags(int newFlags) {
        return this.construct(this.key, this.location, newFlags);
    }

    @Override
    public Property copyWithRelocatable(boolean newRelocatable) {
        if (this.relocatable != newRelocatable) {
            return new PropertyImpl(this.key, this.location, this.flags, newRelocatable);
        }
        return this;
    }
}

