/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.path;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Resource;
import org.apache.maven.project.path.PathTranslator;

public class DefaultPathTranslator
implements PathTranslator {
    public void alignToBaseDirectory(Model model, File basedir) {
        Build build = model.getBuild();
        if (build != null) {
            Resource resource;
            build.setDirectory(this.alignToBaseDirectory(build.getDirectory(), basedir));
            build.setSourceDirectory(this.alignToBaseDirectory(build.getSourceDirectory(), basedir));
            build.setTestSourceDirectory(this.alignToBaseDirectory(build.getTestSourceDirectory(), basedir));
            Iterator i = build.getResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            i = build.getTestResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                resource.setDirectory(this.alignToBaseDirectory(resource.getDirectory(), basedir));
            }
            if (build.getFilters() != null) {
                ArrayList<String> filters = new ArrayList<String>();
                Iterator i2 = build.getFilters().iterator();
                while (i2.hasNext()) {
                    String filter = (String)i2.next();
                    filters.add(this.alignToBaseDirectory(filter, basedir));
                }
                build.setFilters(filters);
            }
            build.setOutputDirectory(this.alignToBaseDirectory(build.getOutputDirectory(), basedir));
            build.setTestOutputDirectory(this.alignToBaseDirectory(build.getTestOutputDirectory(), basedir));
        }
    }

    public String alignToBaseDirectory(String path, File basedir) {
        if (path == null) {
            return null;
        }
        String s = this.stripBasedirToken(path);
        File file = new File(s);
        s = file.isAbsolute() ? file.getPath() : (file.getPath().startsWith(File.separator) ? file.getAbsolutePath() : new File(new File(basedir, s).toURI().normalize()).getAbsolutePath());
        return s;
    }

    private String stripBasedirToken(String s) {
        String basedirExpr = "${basedir}";
        if (s != null && (s = s.trim()).startsWith(basedirExpr)) {
            s = s.length() > basedirExpr.length() ? s.substring(basedirExpr.length() + 1) : ".";
        }
        return s;
    }

    public void unalignFromBaseDirectory(Model model, File basedir) {
        Build build = model.getBuild();
        if (build != null) {
            Resource resource;
            build.setDirectory(this.unalignFromBaseDirectory(build.getDirectory(), basedir));
            build.setSourceDirectory(this.unalignFromBaseDirectory(build.getSourceDirectory(), basedir));
            build.setTestSourceDirectory(this.unalignFromBaseDirectory(build.getTestSourceDirectory(), basedir));
            Iterator i = build.getResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                resource.setDirectory(this.unalignFromBaseDirectory(resource.getDirectory(), basedir));
            }
            i = build.getTestResources().iterator();
            while (i.hasNext()) {
                resource = (Resource)i.next();
                resource.setDirectory(this.unalignFromBaseDirectory(resource.getDirectory(), basedir));
            }
            if (build.getFilters() != null) {
                ArrayList<String> filters = new ArrayList<String>();
                Iterator i2 = build.getFilters().iterator();
                while (i2.hasNext()) {
                    String filter = (String)i2.next();
                    filters.add(this.unalignFromBaseDirectory(filter, basedir));
                }
                build.setFilters(filters);
            }
            build.setOutputDirectory(this.unalignFromBaseDirectory(build.getOutputDirectory(), basedir));
            build.setTestOutputDirectory(this.unalignFromBaseDirectory(build.getTestOutputDirectory(), basedir));
        }
    }

    public String unalignFromBaseDirectory(String directory, File basedir) {
        String path = basedir.getPath();
        if (directory.startsWith(path)) {
            directory = directory.substring(path.length() + 1).replace('\\', '/');
        }
        return directory;
    }
}

