/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;

public final class JSArguments {
    public static final Object[] EMPTY_ARGUMENTS_ARRAY = new Object[0];
    public static final int RUNTIME_ARGUMENT_COUNT = 2;
    private static final int THIS_OBJECT_INDEX = 0;
    private static final int FUNCTION_OBJECT_INDEX = 1;
    private static final int NEW_TARGET_INDEX = 2;

    private JSArguments() {
    }

    static Object[] createNullArguments() {
        return JSArguments.createZeroArg(Null.instance, null);
    }

    public static Object[] create(Object target, Object function, Object ... userArguments) {
        Object[] arguments = JSArguments.createInitial(target, function, userArguments.length);
        JSArguments.setUserArguments(arguments, 0, userArguments);
        return arguments;
    }

    public static Object[] createInitial(Object target, Object function, int userArgumentCount) {
        Object[] result = new Object[2 + userArgumentCount];
        result[0] = target;
        result[1] = function;
        return result;
    }

    public static Object[] createZeroArg(Object target, Object function) {
        return JSArguments.createInitial(target, function, 0);
    }

    public static Object[] createOneArg(Object target, Object function, Object userArgument) {
        Object[] arguments = JSArguments.createInitial(target, function, 1);
        JSArguments.setUserArgument(arguments, 0, userArgument);
        return arguments;
    }

    public static Object getThisObject(Object[] arguments) {
        return arguments[0];
    }

    public static Object getFunctionObject(Object[] arguments) {
        return arguments[1];
    }

    public static Object getUserArgument(Object[] arguments, int index) {
        return arguments[index + 2];
    }

    public static void setUserArgument(Object[] arguments, int index, Object value) {
        arguments[index + 2] = value;
    }

    public static int getUserArgumentCount(Object[] arguments) {
        return arguments.length - 2;
    }

    public static void setUserArguments(Object[] arguments, int index, Object ... userArguments) {
        JSArguments.arraycopy(userArguments, 0, arguments, 2 + index, userArguments.length);
    }

    public static Object[] extractUserArguments(Object[] arguments) {
        Object[] userArguments = new Object[arguments.length - 2];
        JSArguments.arraycopy(arguments, 2, userArguments, 0, userArguments.length);
        return userArguments;
    }

    public static Object[] extractUserArguments(Object[] arguments, int skip) {
        return JSArguments.extractUserArguments(arguments, skip, 0);
    }

    public static Object[] extractUserArguments(Object[] arguments, int skip, int skipEnd) {
        int offset = 2 + skip;
        Object[] userArguments = new Object[arguments.length - offset - skipEnd];
        JSArguments.arraycopy(arguments, offset, userArguments, 0, userArguments.length);
        return userArguments;
    }

    public static MaterializedFrame getEnclosingFrame(Object[] arguments) {
        DynamicObject functionObject = JSObject.castJSObject(JSArguments.getFunctionObject(arguments));
        if (!JSFunction.isJSFunction(functionObject)) {
            throw Errors.shouldNotReachHere();
        }
        return JSFunction.getEnclosingFrame(functionObject);
    }

    public static void arraycopy(Object[] src, int srcPos, Object[] dest, int destPos, int length) {
        for (int i = 0; i < length; ++i) {
            dest[destPos + i] = src[srcPos + i];
        }
    }

    public static Object[] createWithNewTarget(Object target, Object function, Object newTarget, Object ... userArguments) {
        Object[] arguments = JSArguments.createInitialWithNewTarget(target, function, newTarget, userArguments.length);
        JSArguments.setUserArguments(arguments, 1, userArguments);
        return arguments;
    }

    public static Object[] createInitialWithNewTarget(Object target, Object function, Object newTarget, int userArgumentCount) {
        Object[] arguments = JSArguments.createInitial(target, function, userArgumentCount + 1);
        arguments[2] = newTarget;
        return arguments;
    }

    public static Object getNewTarget(Object[] arguments) {
        return arguments[2];
    }
}

