/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.project.ExtensionDescriptor;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

class ExtensionDescriptorBuilder {
    ExtensionDescriptorBuilder() {
    }

    private String getExtensionDescriptorLocation() {
        return "META-INF/maven/extension.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExtensionDescriptor build(File extensionJar) throws IOException {
        ExtensionDescriptor extensionDescriptor = null;
        if (extensionJar.isFile()) {
            JarFile pluginJar = new JarFile(extensionJar, false);
            try {
                ZipEntry pluginDescriptorEntry = pluginJar.getEntry(this.getExtensionDescriptorLocation());
                if (pluginDescriptorEntry == null) return extensionDescriptor;
                InputStream is = pluginJar.getInputStream(pluginDescriptorEntry);
                extensionDescriptor = this.build(is);
                return extensionDescriptor;
            }
            finally {
                pluginJar.close();
            }
        }
        File pluginXml = new File(extensionJar, this.getExtensionDescriptorLocation());
        if (!pluginXml.canRead()) return extensionDescriptor;
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(pluginXml));
        try {
            extensionDescriptor = this.build(is);
            return extensionDescriptor;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    ExtensionDescriptor build(InputStream is) throws IOException {
        Xpp3Dom dom;
        ExtensionDescriptor extensionDescriptor = new ExtensionDescriptor();
        try {
            dom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((InputStream)is));
        }
        catch (XmlPullParserException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            IOUtil.close((InputStream)is);
        }
        if (!"extension".equals(dom.getName())) {
            throw new IOException("Unexpected root element \"" + dom.getName() + "\", expected \"extension\"");
        }
        extensionDescriptor.setExportedPackages(this.parseStrings(dom.getChild("exportedPackages")));
        extensionDescriptor.setExportedArtifacts(this.parseStrings(dom.getChild("exportedArtifacts")));
        return extensionDescriptor;
    }

    private List<String> parseStrings(Xpp3Dom dom) {
        ArrayList<String> strings = null;
        if (dom != null) {
            strings = new ArrayList<String>();
            for (Xpp3Dom child : dom.getChildren()) {
                String string = child.getValue();
                if (string == null || (string = string.trim()).length() <= 0) continue;
                strings.add(string);
            }
        }
        return strings;
    }
}

