/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.NumberFormatPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSNumberFormat;

public final class NumberFormatPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<NumberFormatPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new NumberFormatPrototypeBuiltins();

    protected NumberFormatPrototypeBuiltins() {
        super("NumberFormat.prototype", NumberFormatPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, NumberFormatPrototype builtinEnum) {
        switch (builtinEnum) {
            case resolvedOptions: {
                return NumberFormatPrototypeBuiltinsFactory.JSNumberFormatResolvedOptionsNodeGen.create(context, builtin, NumberFormatPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case formatToParts: {
                return NumberFormatPrototypeBuiltinsFactory.JSNumberFormatFormatToPartsNodeGen.create(context, builtin, NumberFormatPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSNumberFormatFormatToPartsNode
    extends JSBuiltinNode {
        public JSNumberFormatFormatToPartsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSNumberFormat(numberFormat)"})
        public Object doFormatToParts(DynamicObject numberFormat, Object value) {
            return JSNumberFormat.formatToParts(this.getContext(), numberFormat, value);
        }

        @Fallback
        public void throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected("NumberFormat");
        }
    }

    public static abstract class JSNumberFormatResolvedOptionsNode
    extends JSBuiltinNode {
        public JSNumberFormatResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSNumberFormat(numberFormat)"})
        public Object doResolvedOptions(DynamicObject numberFormat) {
            return JSNumberFormat.resolvedOptions(this.getContext(), numberFormat);
        }

        @Fallback
        public void doResolvedOptions(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected("NumberFormat");
        }
    }

    public static enum NumberFormatPrototype implements BuiltinEnum<NumberFormatPrototype>
    {
        resolvedOptions(0),
        formatToParts(1);

        private final int length;

        private NumberFormatPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

