/* rr.c - Report total RR frames per interval.
   This module is part of report.exe
                  
   Language = Microsoft C version 4.0


   This source is distributed freely and may be copied and
   redistributed with the following provisos:
   
           You may not sell it, nor may you charge for making 
           copies beyond the actual cost of mailing and media.
                      
   Written by Skip Hansen WB6YMH and Harold Price NK6K.

   Feedback is desired.

   RCP/M (213) 541-2503 300/1200/2400 baud
   or via packet WB6YMH @ WB6YMH-2 or 
		 NK6K @ NK6K

   Modification history:

	8/10/87	 	NK6K: Initial release.	
	ver 1.0		 

   10/18/87     NK6K: First general release.
   ver 1.1
*/
#define LINT_ARGS
#include "monfile.h"
#include <stdio.h>
#include <memory.h>
static struct CIRCUIT_RECORD ccrec;
static struct FREQ_RECORD cfrec;

extern FILE *fin,*fout;

static long total_packets;
static long total_rr;
static long total_i;

static char fbuf[257];
static char started;
static unsigned long time_stamp;
static unsigned int all_cir;
static int tmp;
static long recnum;

void rrdump_it();

void
report_rr()
{
   started=0;
   recnum=0;
   
   total_packets=total_i=total_rr=0;
   while (1){
	if (fgets(fbuf,256,fin)==NULL) {
		if (started) rrdump_it();
		return;
		}
	recnum++;
	if (fbuf[0]=='T') {
		if (started) rrdump_it();
		tmp=sscanf(fbuf+2,"%lu",&time_stamp);	
		if (tmp!=1) {
			fprintf(stderr,"*** bad Time rec, number %lu ***\n",recnum);
			}
		started=1;
		}

	else if (fbuf[0]== FREQ_TYPE) {
		tmp=sscanf(fbuf+2,"%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu",
			&cfrec.t_packets,
			&cfrec.t_bytes,
			&cfrec.u_packets,
			&cfrec.u_bytes,
			&cfrec.l32,
			&cfrec.l64,
			&cfrec.l128,
			&cfrec.l256,
			&cfrec.g256,
			&cfrec.dcd_on_ticks,
			&cfrec.dcd_off_ticks);

		if (tmp!=11) {
			fprintf(stderr,"*** bad Freq rec, number %lu ***\n",recnum); 
			break;
			}
		}
		
	else if (fbuf[0]=='C') {
		all_cir++;
		tmp = sscanf(fbuf+2,
"%[^,],%[^,],%u,%u,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,\
%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu,%lu",
		ccrec.to,		
		ccrec.from,		
		&ccrec.digis,		
		&ccrec.pid,
		&ccrec.u_dpackets,	
		&ccrec.nd_dpackets,	
		&ccrec.t_dpackets,	
		&ccrec.nd_packets,	
		&ccrec.t_packets,	
		&ccrec.u_dbytes,		
		&ccrec.nd_dbytes,	
		&ccrec.t_dbytes,		
		&ccrec.nd_bytes,		
		&ccrec.t_bytes,		
		&ccrec.c_time,		
		&ccrec.sabm,
		&ccrec.ua,
		&ccrec.disc,
		&ccrec.dm,
		&ccrec.rej,
		&ccrec.rr,
		&ccrec.rnr,
		&ccrec.i,
		&ccrec.ui,
		&ccrec.frmr,
		&ccrec.poll,
		&ccrec.final,
		&ccrec.l32,	
		&ccrec.l64,	
		&ccrec.l128,
		&ccrec.l256,
		&ccrec.g256);

		if (tmp!=32) {
			fprintf(stderr,"*** bad Circuit rec, number %lu ***\n",recnum); 
			break;
			}

		

/*n* fix this later */
	    if (ccrec.digis==0) 
		if ((ccrec.nd_dpackets-ccrec.u_dpackets) >= 0) {
			total_packets += ccrec.t_packets;
			total_i += ccrec.i;
			total_rr += ccrec.rr;
 			}
		}
	

	}
   }

		

void
rrdump_it()
{

	fprintf(fout,"%lu,%lu,%lu,%lu\n",
		time_stamp, total_packets, total_i, total_rr);

   total_packets=total_i=total_rr=0;


	}

