#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <time.h>
#include <sys/utsname.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/ax25.h>
#include <linux/rose.h>
#include <linux/in.h>
#include <netdb.h>
#include <arpa/inet.h>

#include "config.h"
#include "node.h"
#include "wp.h"
#include "io.h"
#include "axutils.h"
#include "axconfig.h"
#include "nrconfig.h"
#include "procutils.h"
#include "version.h"
#include "mheard.h"
#include "sysinfo.h"

struct cmd *Nodecmds = NULL;

#define nb_wp() 1

void init_nodecmds(void)
{
	add_internal_cmd(&Nodecmds, "?",        1, 1, do_help);
	add_internal_cmd(&Nodecmds, "Bye",      1, 1, do_bye);
	add_internal_cmd(&Nodecmds, "Connect",  1, 1, do_connect);
	add_internal_cmd(&Nodecmds, "Help",     1, 1, do_help);
	add_internal_cmd(&Nodecmds, "Info",     1, 1, do_help);
	add_internal_cmd(&Nodecmds, "Users",    1, 1, do_users);
	add_internal_cmd(&Nodecmds, "Mheard",   1, 1, do_mheard);
	add_internal_cmd(&Nodecmds, "Links",    1, 1, do_links);
	add_internal_cmd(&Nodecmds, "Nodes",    1, 0, do_netrom);
	add_internal_cmd(&Nodecmds, "Ports",    1, 1, do_ports);
	add_internal_cmd(&Nodecmds, "Routes",   1, 1, do_routes);
	add_internal_cmd(&Nodecmds, "Status",   1, 1, do_status);
	add_internal_cmd(&Nodecmds, "SYSop",    3, 0, do_sysop);
	add_internal_cmd(&Nodecmds, "Telnet",   1, 1, do_connect);
	add_internal_cmd(&Nodecmds, "Wp",	1, 1, do_wp);

	/*
	add_internal_cmd(&Nodecmds, "Connect",  1, 1, do_connect);
	add_internal_cmd(&Nodecmds, "Finger",   1, 1, do_finger);
	add_internal_cmd(&Nodecmds, "HOst",     2, 1, do_host);
	add_internal_cmd(&Nodecmds, "PIng",     2, 1, do_ping);
	add_internal_cmd(&Nodecmds, "TAlk",     2, 1, do_talk);
	add_internal_cmd(&Nodecmds, "Telnet",   1, 1, do_connect);
	add_internal_cmd(&Nodecmds, "Users",    1, 1, user_list);
	*/
};

char *roseaddr(char *addr)
{
	static char buf[12];

	if (*addr == '*')
		strcpy(buf, "None       ");
	else
	{
		memcpy(buf, addr, 4);
		buf[4] = ' ';
		memcpy(buf+5, addr+4, 6);
		buf[11] = '\0';
	}
	return(buf);
}

void logout(char *reason)
{
	end_io(User.fd);
	close(User.fd);
	logout_user();
	/* ipc_close(); */
	log(LOGLVL_LOGIN, "%s @ %s logged out: %s", User.call, User.ul_name, reason);
	free_cmdlist(Nodecmds);
	Nodecmds = NULL;
	exit(0);
}

int do_bye(int argc, char **argv)
{
	logout("Bye");
	return 0;	/* Keep gcc happy */
}

struct mheard_list {
	struct mheard_struct	data;
	struct mheard_list	*next;
};

int do_mheard(int argc, char **argv)
{
	int nb;
	FILE *fp;
        struct mheard_struct mh;
        struct mheard_list *list, *new, *tmp, *p;
	char *s, *t, *u;
	long ti;

	/*
	if (argc < 2) {
		node_msg("Usage: mheard <port>");
		return 0;
	}
	if (ax25_config_get_dev(argv[1]) == NULL ||
	    (check_perms(PERM_HIDDEN, 0) == -1 && is_hidden(argv[1]))) {
		node_msg("Invalid port");
		return 0;
	}
	*/
        if ((fp = fopen(DATA_MHEARD_FILE, "r")) == NULL) {
		node_perror(DATA_MHEARD_FILE, errno);
		return 0;
	}
	list = NULL;
	while (fread(&mh, sizeof(struct mheard_struct), 1, fp) == 1) 
	{
		/* if (strcmp(argv[1], mh.portname))
			continue; */
                if ((new = calloc(1, sizeof(struct mheard_list))) == NULL) {
			node_perror("do_mheard: calloc", errno);
			break;
		}
		new->data = mh;
		if (list == NULL || mh.last_heard > list->data.last_heard) {
                        tmp = list;
                        list = new;
                        new->next = tmp;
		} else {
                        for (p = list; p->next != NULL; p = p->next)
                                if (mh.last_heard > p->next->data.last_heard)
                                        break;
                        tmp = p->next;
                        p->next = new;
                        new->next = tmp;
		}
	}
	fclose(fp);

	nb = 0;
	node_msg("Last 20 Heard list for all ports :");
	tprintf("Port   Callsign  Pkts rcvd Mode Time ago\n");
	while (list != NULL) 
	{
		if (nb++ < 20)
		{
			if (list->data.mode & MHEARD_MODE_ROSE)
				s = "FPAC";
			else if (list->data.mode & MHEARD_MODE_NETROM)
				s = "NRom";
			else if (list->data.mode & MHEARD_MODE_FLEXNET)
				s = "Flex";
			else if (list->data.mode & MHEARD_MODE_TEXNET)
				s = "TexN";
			else if (list->data.mode & MHEARD_MODE_TEXT)
				s = "AX25";
			else
				s = "????";

			t = ax2asc(&list->data.from_call);
			if ((u = strstr(t, "-0")) != NULL)
				*u = '\0';
			tprintf("%-6.6s %-9s %-9ld %-4s ", 
			list->data.portname, t, list->data.count, s);
			ti = time(NULL) - list->data.last_heard;
				tprintf("%ldhr %02ldmn %02ld\n", ti / 3600L, (ti % 3600L) / 60L, ti % 60L);	
		}
		tmp = list;
		list = list->next;
		free(tmp);
	}
	return 0;
}

int do_help(int argc, char **argv)
{
	FILE *fp;
	char fname[80], line[256];
	struct cmd *cmdp;
	int i = 0;

	if (*argv[0] == '?') {				/* "?"		*/
		if (is_sysop())
			node_msg("Sysop:");
		else
			node_msg("Commands:");
		for (cmdp = Nodecmds; cmdp != NULL; cmdp = cmdp->next) {
			tprintf("%s%s", i ? ", " : "", cmdp->name);
			if (++i == 10) {
				tprintf("\n");
				i = 0;
			}
		}
		if (is_sysop())
		{
			for (cmdp = Syscmds; cmdp != NULL; cmdp = cmdp->next) {
				tprintf("%s%s", i ? ", " : "", cmdp->name);
				if (++i == 10) {
					tprintf("\n");
					i = 0;
				}
			}
		}
		if (i) tprintf("\n");
		return 0;
	}
	strcpy(fname, DATA_NODE_HELP_DIR);
	if (*argv[0] == 'i') {				/* "info"	*/
		strcpy(fname, CONF_NODE_INFO_FILE);
		node_msg("FPAC-Node v %s for LINUX (F6FBB-1997)", VERSION);
	} else if (argc == 1) {				/* "help"	*/
		strcat(fname, "help.hlp");
	} else {					/* "help <cmd>"	*/
		if (strchr(argv[1], '/') == NULL) {
			strlwr(argv[1]);
			strcat(fname, argv[1]);
			strcat(fname, ".hlp");
		}
	}
	if ((fp = fopen(fname, "r")) == NULL) {
		if (*argv[0] != 'i')
			node_msg("No help for command %s", argv[1] ? argv[1] : "help");
		return 0;
	}
	if (*argv[0] != 'i')
		node_msg("Help for command %s", argv[1] ? argv[1] : "help");
	while (fgets(line, 256, fp) != NULL)
		tputs(line);
	tputs("\n");
	fclose(fp);
	return 0;
}

#if 0
int do_host(int argc, char **argv)
{
	struct hostent *h;
	struct in_addr addr;
	char **p, *cp;

	if (argc < 2) {
		node_msg("Usage: host <hostname>|<ip address>");
		return 0;
	}
	if (inet_aton(argv[1], &addr) != 0)
		h = gethostbyaddr((char *)&addr, sizeof(addr), AF_INET);
	else
		h = gethostbyname(argv[1]);
	if (h == NULL) {
		switch (h_errno) {
		case HOST_NOT_FOUND:
			cp = "Unknown host";
			break;
		case TRY_AGAIN:
			cp = "Temporary name server error";
			break;
		case NO_RECOVERY:
			cp = "Non-recoverable name server error";
			break;
		case NO_ADDRESS:
			cp = "No address";
			break;
		default:
			cp = "Unknown error";
			break;
		}
		node_msg("%s", cp);
		return 0;
	}
	node_msg("Host name information for %s:", argv[1]);
	tprintf("Hostname:    %s\n", h->h_name);
	tputs("Aliases:    ");
	p = h->h_aliases;
	while (*p != NULL) {
		tprintf(" %s", *p);
		p++;
	}
	tputs("\nAddress(es):");
	p = h->h_addr_list;
	while (*p != NULL) {
		addr.s_addr = ((struct in_addr *)(*p))->s_addr;
		tprintf(" %s", inet_ntoa(addr));
		p++;
	}
	tputs("\n");
	return 0;
}

#endif

int do_ports(int argc, char **argv)
{
	char *cp = NULL;

	node_msg("Ports:\nPort   Description");
	while ((cp = ax25_config_get_next(cp)) != NULL) 
	{
		tprintf("%-6s %s\n", cp, ax25_config_get_desc(cp));
	}
	return 0;
}

int do_users(int argc, char **argv)
{
	struct proc_ax25 *p, *list;
	struct proc_rs *rp, *rlist;
	struct proc_rs_route *tp, *tlist;
	struct proc_rs_neigh *pv, *listv;
	char *cp;
	int first;
	int len;

	first = 1;

	if ((list = read_proc_ax25()) == NULL) {
		if (errno)
			node_perror("do_links: read_proc_ax25:", errno);
		return 0;
	}
	for (p = list; p != NULL; p = p->next) 
	{
		if (argc > 1 && strcasecmp(argv[1], "*") && strcasecmp(p->dest_addr, argv[1]) && strcasecmp(p->src_addr, argv[1]))
			continue;
		if ((argc < 2) && !strcmp(p->dest_addr, "*"))
			continue;

		if ((wp_check_call(p->src_addr) != 0) && (wp_check_call(p->dest_addr) != 0))
			continue;
			
		if (first)
		{
			first = 0;
			node_msg("Users - AX.25 L2 Sessions :");
			tprintf("Port   Callsign     Callsign  State");
			if (is_sysop())
				tprintf("        Unack T1      Retr  Rtt Snd-Q Rcv-Q");
			tprintf("\n");
		}

		len = strlen(p->src_addr);
		if ((len > 0) && (p->src_addr[len-1] == '*'))
			p->src_addr[len-1] = '\0';

		cp = ax25_config_get_name(p->dev);
		tprintf("%-6s %-9s -> %-9s ", cp, p->dest_addr, p->src_addr);
		if (!strcmp(p->dest_addr, "*")) {
			tprintf("Listening\n");
			continue;
		}
		switch (p->st) {
		case 0:
			cp = "Disconnected";
			break;
		case 1:
			cp = "Conn pending";
			break;
		case 2:
			cp = "Disc pending";
			break;
		case 3:
			cp = "Connected   ";
			break;
		case 4:
			cp = "Recovery    ";
			break;
		default:
			cp = "Unknown     ";
			break;
		}
		tprintf("%s", cp);
		if (is_sysop())
		{
			tprintf(" %02d/%02d %03d/%03d %02d/%02d %-3d %-5d %-5d",
				p->vs < p->va ? p->vs - p->va + 8 : p->vs - p->va,
				p->window,
				p->t1timer, p->t1,
				p->n2count, p->n2,
				p->rtt,
				p->sndq, p->rcvq);
		}
		tprintf("\n");
	}
	free_proc_ax25(list);

	first = 1;

	if ((rlist = read_proc_rs()) == NULL) {
		if (errno)
			node_perror("do_links: read_proc_ax25:", errno);
		return 0;
	}
	for (rp = rlist; rp != NULL; rp = rp->next) 
	{
		if (argc > 1 && strcasecmp(argv[1], "*") && strcasecmp(rp->dest_call, argv[1]) && strcasecmp(rp->src_call, argv[1]))
			continue;
		if ((argc < 2) && !strcmp(rp->dest_addr, "*"))
			continue;

		if ((wp_check_call(rp->src_call) != 0) && (wp_check_call(rp->dest_call) != 0))
			continue;
			
		if (rp->lci >= 2048)
			continue;
			
		if (first)
		{
			first = 0;
			tprintf("\n");
			node_msg("Users - X.25 L3 Sessions :");
			tprintf("Callsign  DNIC addr   Callsign  DNIC addr   LCI State");
			if (is_sysop())
				tprintf("        Unack Snd-Q Rcv-Q");
			tprintf("\n");
		}

		tprintf("%-9s %-10s ", 
			rp->dest_call, roseaddr(rp->dest_addr));
		tprintf("%-9s %-10s %03X ", 
			rp->src_call, roseaddr(rp->src_addr), 
			rp->lci);
		if (!strcmp(rp->dest_addr, "*")) {
			tprintf("Listening\n");
			continue;
		}
		switch (rp->st) {
		case 0:
			cp = "Disconnected";
			break;
		case 1:
			cp = "Conn pending";
			break;
		case 2:
			cp = "Disc pending";
			break;
		case 3:
			cp = "Connected   ";
			break;
		case 4:
			cp = "Recovery    ";
			break;
		default:
			cp = "Unknown     ";
			break;
		}
		tprintf("%s", cp);
		if (is_sysop())
		{
			tprintf(" %02d    %-5d %-5d\n",
				rp->vs < rp->va ? rp->vs - rp->va + 8 : rp->vs - rp->va,
				rp->sndq, rp->rcvq);
		}
		tprintf("\n");
	}
	free_proc_rs(rlist);

	if ((listv = read_proc_rs_neigh()) == NULL) {
		if (errno)
		{
			node_perror("do_routes: read_proc_nr_neigh", errno);
			return 0;
		}
	}
	if ((tlist = read_proc_rs_routes()) == NULL) {
		if (errno)
		{
			node_perror("do_links: read_proc_ax25:", errno);
			return 0;
		}
	}

	first = 1;

	for (tp = tlist; tp != NULL; tp = tp->next) 
	{
		char nei1[20], nei2[20];

		if (argc > 1 && strcasecmp(argv[1], "*") && strcasecmp(tp->call1, argv[1]) && strcasecmp(tp->call2, argv[1]))
			continue;

		/* Do not display no-peers */
		if ((argc < 2) && (!strcmp(tp->address1, "*") || !strcmp(tp->address2, "*")))
			continue;
		
		if (first)
		{
			first = 0;
			tprintf("\n");
			node_msg("Users - X.25 L3 Transits :");
			tprintf("Callsign  DNIC addr   LCI Adjacent   Callsign  DNIC addr   LCI Adajcent\n");
		}

		*nei1 = '\0';
		for (pv = listv ; pv != NULL ; pv = pv->next)
			if (tp->neigh1 == pv->addr)
				sprintf(nei1, "(%s)", pv->call);
		tprintf("%-9s %-10s %03X %-11s",
			tp->call1, roseaddr(tp->address1),
			tp->lci1, nei1);

		*nei2 = '\0';
		for (pv = listv ; pv != NULL ; pv = pv->next)
			if (tp->neigh2 == pv->addr)
				sprintf(nei2, "(%s)", pv->call);
		tprintf("%-9s %-10s %03X %s\n", 
			tp->call2, roseaddr(tp->address2), 
			tp->lci2, nei2);

	}
	free_proc_rs_routes(tlist);
	free_proc_rs_neigh(listv);

	return 0;
}

int do_routes(int argc, char **argv)
{
	struct proc_rs_neigh *pv, *listv;
	struct proc_rs_nodes *pn, *listn;
	int i;
	int loopback = -1;

	node_msg("Routes:\nDNIC Address Adjacent");
	if ((listv = read_proc_rs_neigh()) == NULL) {
		if (errno)
			node_perror("do_routes: read_proc_nr_neigh", errno);
		return 0;
	}

	/* Search the node number of the loopback */
	for (pv = listv ; pv != NULL ; pv = pv->next)
		if (strncmp(pv->call, "RSLOOP", 6) == 0)
		{
			loopback = pv->addr;
			break;
		}

	if ((listn = read_proc_rs_nodes()) == NULL) {
		if (errno)
			node_perror("do_routes: read_proc_nr_neigh", errno);
		return 0;
	}
	for (pn = listn; pn != NULL; pn = pn->next) 
	{
		if (pn->neigh1 == loopback)
			continue;
			
		for (i = pn->mask ; i < 10 ; i++)
			pn->address[i] = '.';
		tprintf("%s ", roseaddr(pn->address));
		for (pv = listv ; pv != NULL ; pv = pv->next)
			if (pn->neigh1 == pv->addr)
				tprintf(" %-9s", pv->call);
		for (pv = listv ; pv != NULL ; pv = pv->next)
			if (pn->neigh2 == pv->addr)
				tprintf(" %-9s", pv->call);
		for (pv = listv ; pv != NULL ; pv = pv->next)
			if (pn->neigh3 == pv->addr)
				tprintf(" %-9s", pv->call);
		tprintf("\n");
	}
	free_proc_rs_neigh(listv);
	free_proc_rs_nodes(listn);
	return 0;
}

int do_links(int argc, char **argv)
{
	struct proc_rs_neigh *np, *nlist;

	if ((nlist = read_proc_rs_neigh()) == NULL) {
		node_msg("No FPAC adjacents");
		return 0;
	}
	/* "nodes" */
	node_msg("Links:\nCallsign  Port   Description");
	for (np = nlist; np != NULL; np = np->next) 
	{
		if (wp_check_call(np->call) != 0)
			continue;
			
		tprintf("%-9s %-6.6s %s\n",
			np->call, ax25_config_get_name(np->dev), 
			ax25_config_get_desc(ax25_config_get_name(np->dev)));
	}
	free_proc_rs_neigh(nlist);
	return 0;
}

int do_netrom(int argc, char **argv)
{
	struct proc_nr_nodes *p, *list;
	struct proc_nr_neigh *np, *nlist;
	int i = 0;

	if ((list = read_proc_nr_nodes()) == NULL) {
		node_msg("No Netrom node");
		return 0;
	}
	/* "nodes" */
	if (argc == 1) {
		node_msg("NetRom Nodes:");
		for (p = list; p != NULL; p = p->next) {
			tprintf("%-16.16s %c",
				print_node(p->alias, p->call),
				(++i % 4) ? ' ' : '\n');
		}
		if ((i % 4) != 0) tprintf("\n");
		free_proc_nr_nodes(list);
		return 0;
	}
	if ((nlist = read_proc_nr_neigh()) == NULL) {
		node_msg("No Netrom node");
		return 0;
	}
	/* "nodes *" */
	if (*argv[1] == '*') {
		node_msg("NetRom Nodes:");
		tprintf("Node              Quality Obsolescence Port   Neighbour\n");
		for (p = list; p != NULL; p = p->next) {
			tprintf("%-16.16s  ", print_node(p->alias, p->call));
			if ((np = find_neigh(p->addr1, nlist)) != NULL) {
				tprintf("%-7d %-12d %-6s %s\n",
					p->qual1, p->obs1,
					ax25_config_get_name(np->dev),
					np->call);
			}
			if (p->n > 1 && (np = find_neigh(p->addr2, nlist)) != NULL) {
				tprintf("                  ");
				tprintf("%-7d %-12d %-6s %s\n",
					p->qual2, p->obs2,
					ax25_config_get_name(np->dev),
					np->call);
			}
			if (p->n > 2 && (np = find_neigh(p->addr3, nlist)) != NULL) {
				tprintf("                  ");
				tprintf("%-7d %-12d %-6s %s\n",
					p->qual3, p->obs3,
					ax25_config_get_name(np->dev),
					np->call);
			}
		}
		free_proc_nr_nodes(list);
		free_proc_nr_neigh(nlist);
		return 0;
	}
	/* "nodes <node>" */
	p = find_node(argv[1], list);
	if (p != NULL) {
		node_msg("Routes to: %s", print_node(p->alias, p->call));
		tprintf("Which Quality Obsolescence Port   Neighbour\n");
		if ((np = find_neigh(p->addr1, nlist)) != NULL) {
			tprintf("%c     %-7d %-12d %-6s %s\n",
				p->w == 1 ? '>' : ' ',
				p->qual1, p->obs1,
				ax25_config_get_name(np->dev),
				np->call);
		}
		if (p->n > 1 && (np = find_neigh(p->addr2, nlist)) != NULL) {
			tprintf("%c     %-7d %-12d %-6s %s\n",
				p->w == 2 ? '>' : ' ',
				p->qual2, p->obs2,
				ax25_config_get_name(np->dev),
				np->call);
		}
		if (p->n > 1 && (np = find_neigh(p->addr3, nlist)) != NULL) {
			tprintf("%c     %-7d %-12d %-6s %s\n",
				p->w == 3 ? '>' : ' ',
				p->qual3, p->obs3,
				ax25_config_get_name(np->dev),
				np->call);
		}
	} else {
		node_msg("No such node");
	}
	free_proc_nr_nodes(list);
	free_proc_nr_neigh(nlist);
	return 0;
}

/*
 * by Heikki Hannikainen <hessu@pspt.fi> 
 * The following was mostly learnt from the procps package and the
 * gnu sh-utils (mainly uname).
 */

int do_status(int argc, char **argv)
{
	int upminutes, uphours, updays;
	double uptime_secs, idle_secs;
	double av[3];
	unsigned **mem;
	struct utsname name;
	time_t t;
	int n;
	int loopback = -1;

	node_msg("Status:");
	time(&t);
	tprintf("System time      : %s", ctime(&t));
	if (uname(&name) == -1)
		tprintf("Cannot get system name\n");
	else {
		tprintf("Hostname         : %s\n", name.nodename);
		tprintf("Operating system : %s %s (%s)\n", name.sysname,
			name.release, name.machine);
	}
	/* read and calculate the amount of uptime and format it nicely */
	uptime(&uptime_secs, &idle_secs);
	updays = (int) uptime_secs / (60*60*24);
	upminutes = (int) uptime_secs / 60;
	uphours = upminutes / 60;
	uphours = uphours % 24;
	upminutes = upminutes % 60;
	tprintf("Uptime           : ");
  	if (updays)
		tprintf("%d day%s, ", updays, (updays != 1) ? "s" : "");
	if(uphours)
		tprintf("%d hour%s ", uphours, (uphours != 1) ? "s" : "");
	tprintf("%d minute%s\n", upminutes, (upminutes != 1) ? "s" : "");
	loadavg(&av[0], &av[1], &av[2]);
  	tprintf("Load average     : %.2f, %.2f, %.2f\n", av[0], av[1], av[2]);
	if (!(mem = meminfo()) || mem[meminfo_main][meminfo_total] == 0) {
		/* cannot normalize mem usage */
		tprintf("Cannot get memory information!\n");
	} else {
		tprintf("Memory           : %5d KB available, %5d KB used, %5d KB free\n",
			mem[meminfo_main][meminfo_total]    >> 10,
			(mem[meminfo_main][meminfo_used] -
		 	mem[meminfo_main][meminfo_buffers] -
			mem[meminfo_total][meminfo_cached]) >> 10,
			(mem[meminfo_main][meminfo_free] +
		 	mem[meminfo_main][meminfo_buffers] +
			mem[meminfo_total][meminfo_cached]) >> 10);
		tprintf("Swap             : %5d KB available, %5d KB used, %5d KB free\n\n",
			mem[meminfo_swap][meminfo_total]   >> 10,
			mem[meminfo_swap][meminfo_used]    >> 10,
			mem[meminfo_swap][meminfo_free]    >> 10);
	}

	{
		struct proc_ax25 *p, *list;

		if ((list = read_proc_ax25()) == NULL && errno != 0)
			node_perror("do_status: read_proc_ax25", errno);

		n = 0;
		for (p = list; p != NULL; p = p->next) 
		{
			if (!strcmp(p->dest_addr, "*"))
				continue;
			++n;
		}
		tprintf("L2 Users         : %d\n", n);
		free_proc_ax25(list);
	}

	{
		struct proc_rs *rp, *rlist;

		if ((rlist = read_proc_rs()) == NULL && errno != 0)
			node_perror("do_status: read_proc_rs", errno);

		n = 0;
		for (rp = rlist; rp != NULL; rp = rp->next) 
		{
			if (!strcmp(rp->dest_addr, "*"))
				continue;

			if ((wp_check_call(rp->src_call) != 0) && (wp_check_call(rp->dest_call) != 0))
				continue;
			
			if (rp->lci >= 2048)
				continue;
			
			++n;
		}
		tprintf("FPAC L3 Users    : %d\n", n);
		free_proc_rs(rlist);
	}

	{
		struct proc_rs_route *tp, *tlist;

		if ((tlist = read_proc_rs_routes()) == NULL && errno != 0)
			node_perror("do_links: read_proc_ax25:", errno);

		n = 0;
		for (tp = tlist; tp != NULL; tp = tp->next) 
		{
			/* Do not display no-peers */
			if ((argc < 2) && (!strcmp(tp->address1, "*") || !strcmp(tp->address2, "*")))
				continue;
		
			++n;
		}
		tprintf("FPAC L3 Transits : %d\n", n);
		free_proc_rs_routes(tlist);
	}
	
	{
		struct proc_rs_neigh *rp, *rlist;

		if ((rlist = read_proc_rs_neigh()) == NULL && errno != 0)
			node_perror("do_status: read_proc_rs_neigh", errno);

		n = 0;
		for (rp = rlist; rp != NULL; rp = rp->next) 
		{
			if (strncmp(rp->call, "RSLOOP", 6) == 0)
			{
				loopback = rp->addr;
				continue;
			}
			++n;
		}
		tprintf("FPAC adjacents   : %d\n", n);
		free_proc_rs_neigh(rlist);
	}

	{
		struct proc_rs_nodes *rp, *rlist;

		if ((rlist = read_proc_rs_nodes()) == NULL && errno != 0)
			node_perror("do_status: read_proc_rs_nodes", errno);

		n = 0;
		for (rp = rlist; rp != NULL; rp = rp->next) 
		{
			if (rp->neigh1 == loopback)
				continue;
			++n;
		}
		tprintf("FPAC Routes      : %d\n", n);
		free_proc_rs_nodes(rlist);
	}

	tprintf("FPAC White Pages : %ld\n", wp_nb_records());

	return 0;
}

static char *my_date(time_t date)
{
	static char buf[20];
	struct tm *sdate;

	sdate = localtime (&date);
	sprintf(buf, "%02d/%02d/%02d %02d:%02d", 
		sdate->tm_mday,
		sdate->tm_mon + 1, 
		sdate->tm_year%100,
		sdate->tm_hour,
		sdate->tm_min);
	return(buf);
}

int do_wp(int argc, char**argv)
{
	int i;
	ax25_address addr;
	wp_t wp;
	char *add;
	char dnic[5];

	if (argc < 2)
	{
		node_msg("Usage: wp <callsign-ssid>");
		return(1);
	}

	if (convert_call_entry(strupr(argv[1]), addr.ax25_call) != 0)
	{
		node_msg("Invalid callsign %s", argv[1]);
		return(1);
	}

	if (wp_get(&addr, &wp))
	{
		node_msg("Not found %s !", ax2asc(&addr));
		return(1);
	}

	add = rose2asc(&wp.address.srose_addr);

	tprintf("Callsign  Last update       DNIC address digis (%d records)\n", nb_wp());

	strncpy(dnic, add, 4); dnic[4] = '\0';

	tprintf("%-9s %s => %s %s ", 
		argv[1], my_date(wp.date), dnic, add+4);

	for (i = 0 ; i < wp.address.srose_ndigis ; i++)
	{
		if (i > 1)
			break;
		tprintf("%s ", ax2asc(&wp.address.srose_digi));
	}

	tprintf("%s %s\n", wp.name, wp.city);

	return(0);
}

