/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.compaction;

import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.util.Retry;
import org.apache.accumulo.server.compaction.RetryableThriftFunction;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableThriftCall<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RetryableThriftCall.class);
    public static final long MAX_WAIT_TIME = 60000L;
    private final RetryableThriftFunction<T> function;
    private final Retry retry;

    public RetryableThriftCall(long start, long maxWaitTime, int maxNumRetries, RetryableThriftFunction<T> function) {
        this.function = function;
        Retry.NeedsRetryDelay builder = null;
        builder = maxNumRetries == 0 ? Retry.builder().infiniteRetries() : Retry.builder().maxRetries((long)maxNumRetries);
        this.retry = builder.retryAfter(start, TimeUnit.MILLISECONDS).incrementBy(0L, TimeUnit.MILLISECONDS).maxWait(maxWaitTime, TimeUnit.MILLISECONDS).backOffFactor(2.0).logInterval(1L, TimeUnit.MINUTES).createRetry();
    }

    public T run() throws RetriesExceededException {
        T result = null;
        int errorsSeen = 0;
        do {
            try {
                result = this.function.execute();
            }
            catch (TException e) {
                if (++errorsSeen >= 5 && errorsSeen % 5 == 0) {
                    LOG.warn("Error in Thrift function, retrying ...", (Throwable)e);
                }
                LOG.debug("Error in Thrift function, retrying ...", (Throwable)e);
            }
            if (result != null) continue;
            if (this.retry.canRetry()) {
                this.retry.useRetry();
                try {
                    this.retry.waitForNextAttempt(LOG, "making a thrift RPC");
                }
                catch (InterruptedException e) {
                    LOG.error("Error waiting for next attempt: {}, retrying now.", (Object)e.getMessage(), (Object)e);
                }
                continue;
            }
            throw new RetriesExceededException("Maximum number of retries (" + this.retry.retriesCompleted() + ") attempted.");
        } while (null == result);
        return result;
    }

    public static class RetriesExceededException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RetriesExceededException() {
        }

        public RetriesExceededException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }

        public RetriesExceededException(String message, Throwable cause) {
            super(message, cause);
        }

        public RetriesExceededException(String message) {
            super(message);
        }

        public RetriesExceededException(Throwable cause) {
            super(cause);
        }
    }
}

