/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import com.google.auto.service.AutoService;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.util.MonitorUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.zookeeper.KeeperException;

@AutoService(value={KeywordExecutable.class})
public class Info
implements KeywordExecutable {
    public String keyword() {
        return "info";
    }

    public KeywordExecutable.UsageGroup usageGroup() {
        return KeywordExecutable.UsageGroup.CORE;
    }

    public String description() {
        return "Prints Accumulo cluster info";
    }

    public void execute(String[] args) throws KeeperException, InterruptedException {
        ServerContext context = new ServerContext(SiteConfiguration.auto());
        System.out.println("monitor: " + MonitorUtil.getLocation((ClientContext)context));
        System.out.println("managers: " + String.valueOf(context.getManagerLocations()));
        System.out.println("zookeepers: " + context.getZooKeepers());
    }

    public static void main(String[] args) throws Exception {
        new Info().execute(args);
    }
}

