/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.compactions;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.iteratorsImpl.system.SystemIteratorUtil;
import org.apache.accumulo.core.metadata.StoredTabletFile;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.ExternalCompactionId;
import org.apache.accumulo.core.spi.compaction.CompactionKind;
import org.apache.accumulo.core.tabletserver.thrift.InputFile;
import org.apache.accumulo.core.tabletserver.thrift.IteratorConfig;
import org.apache.accumulo.core.tabletserver.thrift.TCompactionKind;
import org.apache.accumulo.core.tabletserver.thrift.TExternalCompactionJob;

public class ExternalCompactionJob {
    private Map<StoredTabletFile, DataFileValue> jobFiles;
    private boolean propagateDeletes;
    private TabletFile compactTmpName;
    private KeyExtent extent;
    private ExternalCompactionId externalCompactionId;
    private CompactionKind kind;
    private List<IteratorSetting> iters;
    private long userCompactionId;
    private Map<String, String> overrides;

    public ExternalCompactionJob() {
    }

    public ExternalCompactionJob(Map<StoredTabletFile, DataFileValue> jobFiles, boolean propagateDeletes, TabletFile compactTmpName, KeyExtent extent, ExternalCompactionId externalCompactionId, CompactionKind kind, List<IteratorSetting> iters, Long userCompactionId, Map<String, String> overrides) {
        this.jobFiles = Objects.requireNonNull(jobFiles);
        this.propagateDeletes = propagateDeletes;
        this.compactTmpName = Objects.requireNonNull(compactTmpName);
        this.extent = Objects.requireNonNull(extent);
        this.externalCompactionId = Objects.requireNonNull(externalCompactionId);
        this.kind = Objects.requireNonNull(kind);
        this.iters = Objects.requireNonNull(iters);
        if (kind == CompactionKind.USER) {
            Preconditions.checkArgument((userCompactionId != null && userCompactionId > 0L ? 1 : 0) != 0);
            this.userCompactionId = userCompactionId;
        } else {
            this.userCompactionId = 0L;
        }
        this.overrides = overrides;
    }

    public TExternalCompactionJob toThrift() {
        IteratorConfig iteratorSettings = SystemIteratorUtil.toIteratorConfig(this.iters);
        List files = this.jobFiles.entrySet().stream().map(e -> {
            DataFileValue dfv = (DataFileValue)e.getValue();
            return new InputFile(((StoredTabletFile)e.getKey()).getPathStr(), dfv.getSize(), dfv.getNumEntries(), dfv.getTime());
        }).collect(Collectors.toList());
        return new TExternalCompactionJob(this.externalCompactionId.toString(), this.extent.toThrift(), files, iteratorSettings, this.compactTmpName.getPathStr(), this.propagateDeletes, TCompactionKind.valueOf((String)this.kind.name()), this.userCompactionId, this.overrides);
    }

    public ExternalCompactionId getExternalCompactionId() {
        return this.externalCompactionId;
    }

    public KeyExtent getExtent() {
        return this.extent;
    }
}

