/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.security.tokens;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.apache.hadoop.io.Writable;

public interface AuthenticationToken
extends Writable,
Destroyable,
Cloneable {
    public void init(Properties var1);

    public Set<TokenProperty> getProperties();

    public AuthenticationToken clone();

    public static class TokenProperty
    implements Comparable<TokenProperty> {
        private final String key;
        private final String description;
        private final boolean masked;

        public TokenProperty(String name, String description, boolean mask) {
            this.key = name;
            this.description = description;
            this.masked = mask;
        }

        public String toString() {
            return this.key + " - " + this.description;
        }

        public String getKey() {
            return this.key;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean getMask() {
            return this.masked;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof TokenProperty) {
                return ((TokenProperty)o).key.equals(this.key);
            }
            return false;
        }

        @Override
        public int compareTo(TokenProperty o) {
            return this.key.compareTo(o.key);
        }
    }

    public static class Properties
    implements Destroyable,
    Map<String, char[]> {
        private boolean destroyed = false;
        private final HashMap<String, char[]> map = new HashMap();

        private void checkDestroyed() {
            if (this.destroyed) {
                throw new IllegalStateException();
            }
        }

        @Override
        public char[] put(String key, CharSequence value) {
            this.checkDestroyed();
            char[] toPut = new char[value.length()];
            for (int i = 0; i < value.length(); ++i) {
                toPut[i] = value.charAt(i);
            }
            return this.map.put(key, toPut);
        }

        public void putAllStrings(Map<String, ? extends CharSequence> map) {
            this.checkDestroyed();
            for (Map.Entry<String, ? extends CharSequence> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void destroy() throws DestroyFailedException {
            for (String key : this.keySet()) {
                char[] val = this.get(key);
                Arrays.fill(val, '\u0000');
            }
            this.clear();
            this.destroyed = true;
        }

        @Override
        public boolean isDestroyed() {
            return this.destroyed;
        }

        @Override
        public int size() {
            this.checkDestroyed();
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            this.checkDestroyed();
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            this.checkDestroyed();
            String k = (String)key;
            return this.map.containsKey(k);
        }

        @Override
        public boolean containsValue(Object value) {
            this.checkDestroyed();
            char[] v = (char[])value;
            return this.map.containsValue(v);
        }

        @Override
        public char[] get(Object key) {
            this.checkDestroyed();
            String k = (String)key;
            return this.map.get(k);
        }

        @Override
        public char[] put(String key, char[] value) {
            this.checkDestroyed();
            return this.map.put(key, value);
        }

        @Override
        public char[] remove(Object key) {
            this.checkDestroyed();
            String k = (String)key;
            return this.map.remove(k);
        }

        @Override
        public void putAll(Map<? extends String, ? extends char[]> m) {
            this.checkDestroyed();
            this.map.putAll(m);
        }

        @Override
        public void clear() {
            this.checkDestroyed();
            this.map.clear();
        }

        @Override
        public Set<String> keySet() {
            this.checkDestroyed();
            return this.map.keySet();
        }

        @Override
        public Collection<char[]> values() {
            this.checkDestroyed();
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<String, char[]>> entrySet() {
            this.checkDestroyed();
            return this.map.entrySet();
        }
    }

    public static final class AuthenticationTokenSerializer {
        public static <T extends AuthenticationToken> T deserialize(Class<T> tokenType, byte[] tokenBytes) {
            AuthenticationToken type = null;
            try {
                type = (AuthenticationToken)tokenType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot instantiate " + tokenType.getName(), e);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(tokenBytes);
            DataInputStream in = new DataInputStream(bais);
            try {
                type.readFields(in);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Cannot deserialize provided byte array as class " + tokenType.getName(), e);
            }
            try {
                in.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Shouldn't happen", e);
            }
            return (T)type;
        }

        public static AuthenticationToken deserialize(String tokenClassName, byte[] tokenBytes) {
            try {
                Class<?> tokenType = Class.forName(tokenClassName);
                return AuthenticationTokenSerializer.deserialize(tokenType, tokenBytes);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Class not available " + tokenClassName, e);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public static byte[] serialize(AuthenticationToken token) {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DataOutputStream out = new DataOutputStream(baos);){
                    token.write(out);
                    byArray = baos.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new RuntimeException("Bug found in serialization code", e);
            }
        }
    }
}

