/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class PeekingIterator<E>
implements Iterator<E> {
    boolean isInitialized;
    Iterator<E> source;
    E top;
    boolean hasNext;

    public PeekingIterator(Iterator<E> source) {
        this.initialize(source);
    }

    public PeekingIterator() {
        this.isInitialized = false;
    }

    public PeekingIterator<E> initialize(Iterator<E> source) {
        this.source = source;
        if (source.hasNext()) {
            this.top = source.next();
            this.hasNext = true;
        } else {
            this.top = null;
            this.hasNext = false;
        }
        this.isInitialized = true;
        return this;
    }

    public E peek() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Iterator has not yet been initialized");
        }
        return this.top;
    }

    @Override
    public E next() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Iterator has not yet been initialized");
        }
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        E lastPeeked = this.top;
        if (this.source.hasNext()) {
            this.top = this.source.next();
            this.hasNext = true;
        } else {
            this.top = null;
            this.hasNext = false;
        }
        return lastPeeked;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        if (!this.isInitialized) {
            throw new IllegalStateException("Iterator has not yet been initialized");
        }
        return this.hasNext;
    }

    public boolean findWithin(Predicate<E> predicate, int limit) {
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0);
        for (int i = 0; i < limit; ++i) {
            if (predicate.test(this.peek())) {
                return true;
            }
            if (i >= limit - 1) continue;
            if (this.hasNext()) {
                this.next();
                continue;
            }
            return false;
        }
        return false;
    }
}

