/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { createApp } from 'vue'
import { createI18n } from 'vue-i18n'

export function withSetup<T>(composable: any, payload?: T) {
  let result: any
  const app = createApp({
    setup() {
      result = composable(payload)
      return () => {}
    }
  })
  app.mount(document.createElement('div'))
  return [result, app]
}

export function i18nPlugins(messages?: Record<string, any>) {
  return createI18n({
    legacy: false, // Use Composition API style
    locale: 'en',
    messages: messages ?? {}
  })
}
