/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.google.drive.internal;

import java.lang.reflect.Method;
import java.util.List;

import com.google.api.services.drive.Drive.Files;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for com.google.api.services.drive.Drive$Files
 */
public enum DriveFilesApiMethod implements ApiMethod {

    COPY(
        com.google.api.services.drive.Drive.Files.Copy.class,
        "copy",
        arg("fileId", String.class),
        arg("file", com.google.api.services.drive.model.File.class)),

    CREATE(
        com.google.api.services.drive.Drive.Files.Create.class,
        "create",
        arg("content", com.google.api.services.drive.model.File.class)),

    CREATE_1(
        com.google.api.services.drive.Drive.Files.Create.class,
        "create",
        arg("content", com.google.api.services.drive.model.File.class),
        arg("mediaContent", com.google.api.client.http.AbstractInputStreamContent.class)),

    DELETE(
        com.google.api.services.drive.Drive.Files.Delete.class,
        "delete",
        arg("fileId", String.class)),

    DOWNLOAD(
        com.google.api.services.drive.Drive.Files.Download.class,
        "download",
        arg("fileId", String.class)),

    EMPTY_TRASH(
        com.google.api.services.drive.Drive.Files.EmptyTrash.class,
        "emptyTrash"),

    EXPORT(
        com.google.api.services.drive.Drive.Files.Export.class,
        "export",
        arg("fileId", String.class),
        arg("mimeType", String.class)),

    GENERATE_IDS(
        com.google.api.services.drive.Drive.Files.GenerateIds.class,
        "generateIds"),

    GET(
        com.google.api.services.drive.Drive.Files.Get.class,
        "get",
        arg("fileId", String.class)),

    LIST(
        com.google.api.services.drive.Drive.Files.List.class,
        "list"),

    LIST_LABELS(
        com.google.api.services.drive.Drive.Files.ListLabels.class,
        "listLabels",
        arg("fileId", String.class)),

    MODIFY_LABELS(
        com.google.api.services.drive.Drive.Files.ModifyLabels.class,
        "modifyLabels",
        arg("fileId", String.class),
        arg("modifyLabelsRequest", com.google.api.services.drive.model.ModifyLabelsRequest.class)),

    UPDATE(
        com.google.api.services.drive.Drive.Files.Update.class,
        "update",
        arg("fileId", String.class),
        arg("file", com.google.api.services.drive.model.File.class)),

    UPDATE_1(
        com.google.api.services.drive.Drive.Files.Update.class,
        "update",
        arg("fileId", String.class),
        arg("file", com.google.api.services.drive.model.File.class),
        arg("mediaContent", com.google.api.client.http.AbstractInputStreamContent.class)),

    WATCH(
        com.google.api.services.drive.Drive.Files.Watch.class,
        "watch",
        arg("fileId", String.class),
        arg("channel", com.google.api.services.drive.model.Channel.class));

    private final ApiMethod apiMethod;

    private DriveFilesApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(Files.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
