/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.AbstractBufferClusteringPrefix;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ObjectSizes;

public class BufferClustering
extends AbstractBufferClusteringPrefix
implements Clustering<ByteBuffer> {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new BufferClustering(EMPTY_VALUES_ARRAY));

    public BufferClustering(ByteBuffer ... values) {
        super(ClusteringPrefix.Kind.CLUSTERING, values);
    }

    @Override
    public long unsharedHeapSize() {
        if (this == Clustering.EMPTY || this == Clustering.STATIC_CLUSTERING) {
            return 0L;
        }
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf((ByteBuffer[])this.values);
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        if (this == Clustering.EMPTY || this == Clustering.STATIC_CLUSTERING) {
            return 0L;
        }
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingDataOf((ByteBuffer[])this.values);
    }

    public static BufferClustering make(ByteBuffer ... values) {
        return new BufferClustering(values);
    }
}

