/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.range;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.locator.EndpointsForRange;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.locator.ReplicaPlans;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.reads.DataResolver;
import org.apache.cassandra.service.reads.ReadCallback;
import org.apache.cassandra.service.reads.range.RangeCommandIterator;
import org.apache.cassandra.service.reads.range.SingleRangeResponse;
import org.apache.cassandra.service.reads.repair.NoopReadRepair;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.Dispatcher;
import org.apache.cassandra.utils.CloseableIterator;

public class ScanAllRangesCommandIterator
extends RangeCommandIterator {
    private final Keyspace keyspace;

    ScanAllRangesCommandIterator(Keyspace keyspace, CloseableIterator<ReplicaPlan.ForRangeRead> replicaPlans, PartitionRangeReadCommand command, int totalRangeCount, Dispatcher.RequestTime requestTime) {
        super(replicaPlans, command, totalRangeCount, totalRangeCount, totalRangeCount, requestTime);
        Preconditions.checkState((boolean)command.isTopK());
        this.keyspace = keyspace;
    }

    @Override
    protected PartitionIterator sendNextRequests() {
        HashSet<InetAddressAndPort> replicasToQuery = null;
        ConsistencyLevel consistencyLevel = null;
        while (this.replicaPlans.hasNext()) {
            if (replicasToQuery == null) {
                replicasToQuery = new HashSet<InetAddressAndPort>();
            }
            ReplicaPlan.ForRangeRead replicaPlan = (ReplicaPlan.ForRangeRead)this.replicaPlans.next();
            replicasToQuery.addAll(((EndpointsForRange)replicaPlan.contacts()).endpoints());
            consistencyLevel = replicaPlan.consistencyLevel();
        }
        if (replicasToQuery == null || replicasToQuery.isEmpty()) {
            return EmptyIterators.partition();
        }
        ReplicaPlan.ForRangeRead plan = ReplicaPlans.forFullRangeRead(this.keyspace, consistencyLevel, this.command.dataRange().keyRange(), replicasToQuery, this.totalRangeCount);
        ReplicaPlan.SharedForRangeRead sharedReplicaPlan = ReplicaPlan.shared(plan);
        DataResolver<EndpointsForRange, ReplicaPlan.ForRangeRead> resolver = new DataResolver<EndpointsForRange, ReplicaPlan.ForRangeRead>(this.command, sharedReplicaPlan, NoopReadRepair.instance, this.requestTime, false);
        ReadCallback<EndpointsForRange, ReplicaPlan.ForRangeRead> handler = new ReadCallback<EndpointsForRange, ReplicaPlan.ForRangeRead>(resolver, this.command, sharedReplicaPlan, this.requestTime);
        int nodes = 0;
        for (InetAddressAndPort endpoint : replicasToQuery) {
            Tracing.trace("Enqueuing request to {}", (Object)endpoint);
            Message<ReadCommand> message = this.command.createMessage(false, this.requestTime);
            MessagingService.instance().sendWithCallback(message, endpoint, handler);
            ++nodes;
        }
        this.rangesQueried += plan.vnodeCount();
        ++this.batchesRequested;
        Tracing.trace("Submitted scanning all ranges requests to {} nodes", (Object)nodes);
        return new SingleRangeResponse(resolver, handler, NoopReadRepair.instance);
    }
}

