/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action.dbimport;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.tree.TreePath;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.action.dbimport.TreeManipulationAction;
import org.apache.cayenne.modeler.dialog.db.load.DbImportTreeNode;
import org.apache.cayenne.modeler.editor.dbimport.DbImportTree;
import org.apache.cayenne.modeler.editor.dbimport.DbImportView;
import org.apache.cayenne.modeler.editor.dbimport.DraggableTreePanel;
import org.apache.cayenne.modeler.undo.DbImportTreeUndoableEdit;
import org.apache.cayenne.modeler.util.CayenneAction;

public class MoveImportNodeAction
extends CayenneAction {
    private static final String ICON_NAME = "icon-backward.png";
    private static final String ACTION_NAME = "Include";
    private static final String EMPTY_NAME = "";
    private DbImportTree sourceTree;
    private DbImportTree targetTree;
    private DraggableTreePanel panel;
    protected boolean moveInverted;
    private Map<Class, Class> classMap;

    public MoveImportNodeAction(Application application) {
        super(ACTION_NAME, application);
    }

    MoveImportNodeAction(String actionName, Application application) {
        super(actionName, application);
        this.initMap();
    }

    private void initMap() {
        this.classMap = new HashMap<Class, Class>();
        this.classMap.put(IncludeTable.class, ExcludeTable.class);
        this.classMap.put(IncludeColumn.class, ExcludeColumn.class);
        this.classMap.put(IncludeProcedure.class, ExcludeProcedure.class);
        this.classMap.put(Schema.class, Schema.class);
        this.classMap.put(Catalog.class, Catalog.class);
    }

    @Override
    public String getIconName() {
        return ICON_NAME;
    }

    private boolean canInsert(TreePath path, DbImportTreeNode foundNode) {
        DbImportTreeNode node;
        DbImportTreeNode sourceElement = (DbImportTreeNode)path.getLastPathComponent();
        DbImportTreeNode selectedElement = foundNode == null ? (this.targetTree.getSelectionPath() != null ? ((node = this.targetTree.getSelectedNode()).getUserObject().getClass() == Catalog.class || node.getUserObject().getClass() == Schema.class || node.getUserObject().getClass() == ReverseEngineering.class ? this.targetTree.getSelectedNode() : (DbImportTreeNode)this.targetTree.getSelectionPath().getParentPath().getLastPathComponent()) : this.targetTree.getRootNode()) : foundNode;
        if (this.nodeClassesIsSameTypes(sourceElement, selectedElement) && sourceElement.getSimpleNodeName().equals(selectedElement.getSimpleNodeName())) {
            return false;
        }
        int childCount = selectedElement.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DbImportTreeNode child = (DbImportTreeNode)selectedElement.getChildAt(i);
            if (!this.nodeClassesIsSameTypes(sourceElement, child) || !sourceElement.getSimpleNodeName().equals(child.getSimpleNodeName())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction(ActionEvent e) {
        TreePath[] paths = this.sourceTree.getSelectionPaths();
        TreeManipulationAction action = null;
        String insertableName = EMPTY_NAME;
        DbImportView rootParent = (DbImportView)this.panel.getParent().getParent();
        rootParent.getReverseEngineeringProgress().setVisible(true);
        if (paths != null) {
            boolean isChanged = false;
            ReverseEngineering reverseEngineeringOldCopy = new ReverseEngineering(this.targetTree.getReverseEngineering());
            try {
                for (TreePath path : paths) {
                    DbImportTreeNode selectedElement = (DbImportTreeNode)path.getLastPathComponent();
                    DbImportTreeNode foundNode = this.targetTree.findNodeByParentsChain(this.targetTree.getRootNode(), selectedElement, 0);
                    if (foundNode == null) {
                        for (int i = selectedElement.getParents().size() - 2; i >= 0; --i) {
                            DbImportTreeNode insertedNode = selectedElement.getParents().get(i);
                            DbImportTreeNode previousNode = this.targetTree.findNodeByParentsChain(this.targetTree.getRootNode(), insertedNode, 0);
                            if (previousNode == null) {
                                previousNode = this.targetTree.getRootNode();
                            }
                            TreeManipulationAction manipulationAction = this.panel.getActionByNodeType(insertedNode.getUserObject().getClass());
                            if (!this.canInsert(new TreePath(insertedNode.getPath()), previousNode)) continue;
                            manipulationAction.setFoundNode(previousNode);
                            manipulationAction.setInsertableNodeName(insertedNode.getSimpleNodeName());
                            manipulationAction.setTree(this.targetTree);
                            manipulationAction.setMovedFromDbSchema(true);
                            manipulationAction.actionPerformed(e);
                            manipulationAction.setFoundNode(null);
                            manipulationAction.setMultipleAction(false);
                        }
                    }
                    foundNode = this.targetTree.findNodeByParentsChain(this.targetTree.getRootNode(), selectedElement, 0);
                    action = !this.moveInverted ? this.panel.getActionByNodeType(selectedElement.getUserObject().getClass()) : this.panel.getActionByNodeType(this.classMap.get(selectedElement.getUserObject().getClass()));
                    if (action == null) continue;
                    if (paths.length > 1) {
                        action.setMultipleAction(true);
                    } else {
                        action.setMultipleAction(false);
                    }
                    if (!this.canInsert(path, foundNode)) continue;
                    insertableName = selectedElement.getSimpleNodeName();
                    action.setFoundNode(foundNode);
                    action.setInsertableNodeName(Matcher.quoteReplacement(insertableName));
                    action.setTree(this.targetTree);
                    action.setMovedFromDbSchema(true);
                    action.actionPerformed(e);
                    action.setFoundNode(null);
                    action.resetActionFlags();
                    isChanged = true;
                    this.sourceTree.setSelectionRow(-1);
                    this.panel.getMoveButton().setEnabled(false);
                    this.panel.getMoveInvertButton().setEnabled(false);
                }
                if (paths.length > 1 && this.targetTree.getSelectionPath() != null) {
                    this.getProjectController().setDirty(true);
                    ArrayList<DbImportTreeNode> expandList = this.targetTree.getTreeExpandList();
                    this.targetTree.translateReverseEngineeringToTree(this.targetTree.getReverseEngineering(), false);
                    this.targetTree.expandTree(expandList);
                }
                if (isChanged && !insertableName.equals(EMPTY_NAME)) {
                    ReverseEngineering reverseEngineeringNewCopy = new ReverseEngineering(this.targetTree.getReverseEngineering());
                    DbImportTreeUndoableEdit undoableEdit = new DbImportTreeUndoableEdit(reverseEngineeringOldCopy, reverseEngineeringNewCopy, this.targetTree, this.getProjectController());
                    this.getProjectController().getApplication().getUndoManager().addEdit(undoableEdit);
                }
            }
            finally {
                rootParent.getReverseEngineeringProgress().setVisible(false);
                if (action != null) {
                    action.resetActionFlags();
                }
            }
        }
    }

    private boolean nodeClassesIsSameTypes(DbImportTreeNode sourceElement, DbImportTreeNode selectedElement) {
        if (sourceElement.getUserObject().getClass() == selectedElement.getUserObject().getClass()) {
            return true;
        }
        if (sourceElement.getUserObject().getClass() == IncludeTable.class && (selectedElement.getUserObject().getClass() == IncludeTable.class || selectedElement.getUserObject().getClass() == ExcludeTable.class)) {
            return true;
        }
        return sourceElement.getUserObject().getClass() == IncludeProcedure.class && (selectedElement.getUserObject().getClass() == IncludeProcedure.class || selectedElement.getUserObject().getClass() == ExcludeProcedure.class);
    }

    public void setSourceTree(DbImportTree sourceTree) {
        this.sourceTree = sourceTree;
    }

    public void setTargetTree(DbImportTree targetTree) {
        this.targetTree = targetTree;
    }

    public void setPanel(DraggableTreePanel panel) {
        this.panel = panel;
    }
}

