/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.aninteger;

import org.apache.datasketches.tuple.AnotB;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Intersection;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.aninteger.IntegerSketch;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.testng.annotations.Test;

public class ParameterLeakageTest {
    IntegerSummarySetOperations setOps = new IntegerSummarySetOperations(IntegerSummary.Mode.Sum, IntegerSummary.Mode.Min);

    @Test
    public void checkUnion() {
        IntegerSketch sk1 = new IntegerSketch(4, IntegerSummary.Mode.Sum);
        sk1.update(1L, Integer.valueOf(1));
        IntegerSummary sk1sum = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)sk1)[0];
        IntegerSketch sk2 = new IntegerSketch(4, IntegerSummary.Mode.Sum);
        sk2.update(2L, Integer.valueOf(1));
        IntegerSummary sk2sum = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)sk2)[0];
        Union union = new Union((SummarySetOperations)this.setOps);
        CompactSketch csk = union.union((Sketch)sk1, (Sketch)sk2);
        IntegerSummary[] summaries = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)csk);
        ParameterLeakageTest.println("Union Count: " + summaries.length);
        for (IntegerSummary isum : summaries) {
            if (isum != sk1sum && isum != sk2sum) continue;
            throw new IllegalArgumentException("Parameter Leakage");
        }
    }

    @Test
    public void checkIntersectStateless() {
        IntegerSketch sk1 = new IntegerSketch(4, IntegerSummary.Mode.Sum);
        sk1.update(1L, Integer.valueOf(1));
        IntegerSummary sk1sum = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)sk1)[0];
        IntegerSketch sk2 = new IntegerSketch(4, IntegerSummary.Mode.Sum);
        sk2.update(1L, Integer.valueOf(1));
        IntegerSummary sk2sum = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)sk2)[0];
        Intersection intersect = new Intersection((SummarySetOperations)this.setOps);
        CompactSketch csk = intersect.intersect((Sketch)sk1, (Sketch)sk2);
        IntegerSummary[] summaries = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)csk);
        ParameterLeakageTest.println("Intersect Stateless Count: " + summaries.length);
        for (IntegerSummary isum : summaries) {
            if (isum != sk1sum && isum != sk2sum) continue;
            throw new IllegalArgumentException("Parameter Leakage");
        }
    }

    @Test
    public void checkIntersectStateful() {
        IntegerSketch sk1 = new IntegerSketch(4, IntegerSummary.Mode.Sum);
        sk1.update(1L, Integer.valueOf(1));
        IntegerSummary sk1sum = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)sk1)[0];
        IntegerSketch sk2 = new IntegerSketch(4, IntegerSummary.Mode.Sum);
        sk2.update(1L, Integer.valueOf(1));
        IntegerSummary sk2sum = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)sk2)[0];
        Intersection intersect = new Intersection((SummarySetOperations)this.setOps);
        intersect.intersect((Sketch)sk1);
        intersect.intersect((Sketch)sk2);
        CompactSketch csk = intersect.getResult();
        IntegerSummary[] summaries = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)csk);
        ParameterLeakageTest.println("Intersect Stateful Count: " + summaries.length);
        for (IntegerSummary isum : summaries) {
            if (isum != sk1sum && isum != sk2sum) continue;
            throw new IllegalArgumentException("Parameter Leakage");
        }
    }

    @Test
    public void checkAnotbStateless() {
        IntegerSketch sk1 = new IntegerSketch(4, IntegerSummary.Mode.Sum);
        sk1.update(1L, Integer.valueOf(1));
        CompactSketch csk1 = sk1.compact();
        IntegerSummary sk1sum = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)csk1)[0];
        IntegerSketch sk2 = new IntegerSketch(4, IntegerSummary.Mode.Sum);
        CompactSketch csk = AnotB.aNotB((Sketch)csk1, (Sketch)sk2);
        IntegerSummary[] summaries = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)csk);
        ParameterLeakageTest.println("AnotB Stateless Count: " + summaries.length);
        for (IntegerSummary isum : summaries) {
            if (isum != sk1sum) continue;
            throw new IllegalArgumentException("Parameter Leakage");
        }
    }

    @Test
    public void checkAnotbStateful() {
        IntegerSketch sk1 = new IntegerSketch(4, IntegerSummary.Mode.Sum);
        sk1.update(1L, Integer.valueOf(1));
        CompactSketch csk1 = sk1.compact();
        IntegerSummary sk1sum = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)csk1)[0];
        IntegerSketch sk2 = new IntegerSketch(4, IntegerSummary.Mode.Sum);
        AnotB anotb = new AnotB();
        anotb.setA((Sketch)csk1);
        anotb.notB((Sketch)sk2);
        CompactSketch csk = anotb.getResult(true);
        IntegerSummary[] summaries = ParameterLeakageTest.captureSummaries((Sketch<IntegerSummary>)csk);
        ParameterLeakageTest.println("AnotB Stateful Count: " + summaries.length);
        for (IntegerSummary isum : summaries) {
            if (isum != sk1sum) continue;
            throw new IllegalArgumentException("Parameter Leakage");
        }
    }

    private static IntegerSummary[] captureSummaries(Sketch<IntegerSummary> sk) {
        int entries = sk.getRetainedEntries();
        IntegerSummary[] intSumArr = new IntegerSummary[entries];
        int cnt = 0;
        TupleSketchIterator it = sk.iterator();
        while (it.next()) {
            intSumArr[cnt] = (IntegerSummary)it.getSummary();
            ++cnt;
        }
        return intSumArr;
    }

    static void println(Object o) {
    }
}

