/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.query.QueryExecutionLowMemoryException;
import org.apache.geode.cache.query.QueryExecutionTimeoutException;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.QueryExecutionCanceledException;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class QueryMonitor {
    private static final Logger logger = LogService.getLogger();
    private final InternalCache cache;
    private final long defaultMaxQueryExecutionTime;
    private final ScheduledThreadPoolExecutor executor;
    @MakeNotStatic
    private static volatile MemoryState memoryState = MemoryStateImpl.HEAP_AVAILABLE;
    @MakeNotStatic
    private static volatile long memoryUsedBytes = 0L;

    public QueryMonitor(ScheduledThreadPoolExecutor executor, InternalCache cache, long defaultMaxQueryExecutionTime) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(cache);
        this.cache = cache;
        this.defaultMaxQueryExecutionTime = defaultMaxQueryExecutionTime;
        this.executor = executor;
        this.executor.setRemoveOnCancelPolicy(true);
    }

    public void monitorQueryExecution(ExecutionContext executionContext) {
        this.monitorQueryExecution(executionContext, this.defaultMaxQueryExecutionTime);
    }

    private void monitorQueryExecution(ExecutionContext executionContext, long maxQueryExecutionTime) {
        if (executionContext.isCqQueryContext()) {
            return;
        }
        executionContext.setCancellationTask(this.scheduleCancelationTask(executionContext, maxQueryExecutionTime));
        if (logger.isDebugEnabled()) {
            this.logDebug(executionContext, "Adding thread to QueryMonitor.");
        }
    }

    public void stopMonitoringQueryExecution(ExecutionContext executionContext) {
        executionContext.getCancellationTask().ifPresent(task -> task.cancel(false));
        if (logger.isDebugEnabled()) {
            this.logDebug(executionContext, "Query completed before cancelation.");
        }
    }

    public static void throwExceptionIfQueryOnCurrentThreadIsCanceled() {
        if (ExecutionContext.isCanceled.get().get()) {
            throw new QueryExecutionCanceledException();
        }
    }

    public void stopMonitoring() {
        this.executor.shutdownNow();
    }

    public static boolean isLowMemory() {
        return memoryState.isLowMemory();
    }

    public static long getMemoryUsedBytes() {
        return memoryUsedBytes;
    }

    public void setLowMemory(boolean isLowMemory, long usedBytes) {
        memoryState.setLowMemory(this.executor, isLowMemory, usedBytes, this.cache);
    }

    private ScheduledFuture<?> scheduleCancelationTask(ExecutionContext executionContext, long timeLimitMillis) {
        AtomicBoolean queryCanceledThreadLocal = ExecutionContext.isCanceled.get();
        return memoryState.schedule(() -> {
            CacheRuntimeException exception = memoryState.createCancellationException(timeLimitMillis, executionContext);
            executionContext.setQueryCanceledException(exception);
            queryCanceledThreadLocal.set(true);
        }, timeLimitMillis, TimeUnit.MILLISECONDS, this.executor, executionContext);
    }

    private void logDebug(ExecutionContext executionContext, String message) {
        Thread queryThread = Thread.currentThread();
        logger.debug(message + " QueryMonitor size is: {}, Thread (id): {}, Query: {}, Thread is : {}", (Object)this.executor.getQueue().size(), (Object)queryThread.getId(), (Object)executionContext.getQuery().getQueryString(), (Object)queryThread);
    }

    private static enum MemoryStateImpl implements MemoryState
    {
        HEAP_AVAILABLE{

            @Override
            public void _setLowMemory(ScheduledThreadPoolExecutor executor, boolean isLowMemory, long usedBytes, InternalCache cache) {
                if (isLowMemory) {
                    memoryState = 1.HEAP_EXHAUSTED;
                    this.cancelAllQueries(executor);
                }
            }

            @Override
            public boolean isLowMemory() {
                return false;
            }

            @Override
            public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit, ScheduledExecutorService scheduledExecutorService, ExecutionContext executionContext) {
                return scheduledExecutorService.schedule(command, delay, unit);
            }

            @Override
            public CacheRuntimeException createCancellationException(long timeLimitMillis, ExecutionContext executionContext) {
                String message = String.format("Query execution canceled after exceeding max execution time %sms.", timeLimitMillis);
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("%s %s", message, executionContext));
                }
                return new QueryExecutionTimeoutException(message);
            }

            private void cancelAllQueries(ScheduledThreadPoolExecutor executor) {
                BlockingQueue<Runnable> expirationTaskQueue = executor.getQueue();
                for (Runnable cancelationTask : expirationTaskQueue) {
                    if (!expirationTaskQueue.remove(cancelationTask)) continue;
                    cancelationTask.run();
                }
            }
        }
        ,
        HEAP_EXHAUSTED{

            @Override
            public void _setLowMemory(ScheduledThreadPoolExecutor executor, boolean isLowMemory, long usedBytes, InternalCache cache) {
                if (!isLowMemory) {
                    memoryState = 2.HEAP_AVAILABLE;
                }
            }

            @Override
            public boolean isLowMemory() {
                return true;
            }

            @Override
            public ScheduledFuture<?> schedule(Runnable command, long timeLimitMillis, TimeUnit unit, ScheduledExecutorService scheduledExecutorService, ExecutionContext executionContext) {
                CacheRuntimeException lowMemoryException = this.createCancellationException(timeLimitMillis, executionContext);
                executionContext.setQueryCanceledException(lowMemoryException);
                throw lowMemoryException;
            }

            @Override
            public CacheRuntimeException createCancellationException(long timeLimitMillis, ExecutionContext executionContext) {
                return new QueryExecutionLowMemoryException(String.format("Query execution canceled due to memory threshold crossed in system, memory used: %s bytes.", memoryUsedBytes));
            }
        };


        @Override
        public void setLowMemory(ScheduledThreadPoolExecutor executor, boolean isLowMemory, long usedBytes, InternalCache cache) {
            if (cache.isQueryMonitorDisabledForLowMemory()) {
                return;
            }
            memoryUsedBytes = usedBytes;
            this._setLowMemory(executor, isLowMemory, usedBytes, cache);
        }

        void _setLowMemory(ScheduledThreadPoolExecutor executor, boolean isLowMemory, long usedBytes, InternalCache cache) {
            throw new IllegalStateException("subclass must override");
        }
    }

    private static interface MemoryState {
        public void setLowMemory(ScheduledThreadPoolExecutor var1, boolean var2, long var3, InternalCache var5);

        public ScheduledFuture<?> schedule(Runnable var1, long var2, TimeUnit var4, ScheduledExecutorService var5, ExecutionContext var6);

        public boolean isLowMemory();

        public CacheRuntimeException createCancellationException(long var1, ExecutionContext var3);
    }
}

