/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.table.partition.exchange;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.DDLUtils;
import org.apache.hadoop.hive.ql.ddl.table.partition.exchange.AlterTableExchangePartitionsDesc;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;

public class AlterTableExchangePartitionsOperation
extends DDLOperation<AlterTableExchangePartitionsDesc> {
    public AlterTableExchangePartitionsOperation(DDLOperationContext context, AlterTableExchangePartitionsDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException {
        Map<String, String> partitionSpecs = ((AlterTableExchangePartitionsDesc)this.desc).getPartitionSpecs();
        Table destTable = ((AlterTableExchangePartitionsDesc)this.desc).getDestinationTable();
        Table sourceTable = ((AlterTableExchangePartitionsDesc)this.desc).getSourceTable();
        List<Partition> partitions = this.context.getDb().exchangeTablePartitions(partitionSpecs, sourceTable.getDbName(), sourceTable.getTableName(), destTable.getDbName(), destTable.getTableName());
        for (Partition partition : partitions) {
            this.context.getWork().getInputs().add(new ReadEntity(new Partition(sourceTable, partition.getSpec(), null)));
            DDLUtils.addIfAbsentByName(new WriteEntity(new Partition(sourceTable, partition.getSpec(), null), WriteEntity.WriteType.DELETE), this.context);
            DDLUtils.addIfAbsentByName(new WriteEntity(new Partition(destTable, partition.getSpec(), null), WriteEntity.WriteType.INSERT), this.context);
        }
        return 0;
    }
}

