/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.queries;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.jdbc.QueryHandler;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class ReadyToCleanHandler
implements QueryHandler<List<CompactionInfo>> {
    private final long minOpenTxnWaterMark;
    private final long retentionTime;
    private final int fetchSize;

    public ReadyToCleanHandler(Configuration conf, long minOpenTxnWaterMark, long retentionTime) {
        this.minOpenTxnWaterMark = minOpenTxnWaterMark;
        this.retentionTime = retentionTime;
        this.fetchSize = MetastoreConf.getIntVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_FETCH_SIZE);
    }

    @Override
    public String getParameterizedQueryString(DatabaseProduct databaseProduct) throws MetaException {
        String whereClause = " WHERE \"CQ_STATE\" = 'r' AND \"CQ_TYPE\" != 'c' AND (\"CQ_COMMIT_TIME\" < (" + TxnUtils.getEpochFn(databaseProduct) + " - \"CQ_RETRY_RETENTION\" - " + this.retentionTime + ") OR \"CQ_COMMIT_TIME\" IS NULL)";
        Object queryStr = " \"CQ_ID\", \"cq1\".\"CQ_DATABASE\", \"cq1\".\"CQ_TABLE\", \"cq1\".\"CQ_PARTITION\",  \"CQ_TYPE\", \"CQ_RUN_AS\", \"CQ_HIGHEST_WRITE_ID\", \"CQ_TBLPROPERTIES\", \"CQ_RETRY_RETENTION\",   \"CQ_NEXT_TXN_ID\"";
        if (TxnHandler.ConfVars.useMinHistoryWriteId()) {
            queryStr = (String)queryStr + ", \"MIN_OPEN_WRITE_ID\"";
        }
        queryStr = (String)queryStr + "  FROM \"COMPACTION_QUEUE\" \"cq1\" INNER JOIN (  SELECT MIN(\"CQ_HIGHEST_WRITE_ID\") \"MIN_WRITE_ID_HWM\", \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\"  FROM \"COMPACTION_QUEUE\"" + whereClause + "  GROUP BY \"CQ_DATABASE\", \"CQ_TABLE\", \"CQ_PARTITION\") \"cq2\" ON \"cq1\".\"CQ_DATABASE\" = \"cq2\".\"CQ_DATABASE\"  AND \"cq1\".\"CQ_TABLE\" = \"cq2\".\"CQ_TABLE\"  AND (\"cq1\".\"CQ_PARTITION\" = \"cq2\".\"CQ_PARTITION\"    OR \"cq1\".\"CQ_PARTITION\" IS NULL AND \"cq2\".\"CQ_PARTITION\" IS NULL)  AND \"CQ_HIGHEST_WRITE_ID\" = \"MIN_WRITE_ID_HWM\" ";
        if (TxnHandler.ConfVars.useMinHistoryWriteId()) {
            queryStr = (String)queryStr + "LEFT JOIN (  SELECT MIN(\"MH_WRITEID\") \"MIN_OPEN_WRITE_ID\", \"MH_DATABASE\", \"MH_TABLE\"  FROM \"MIN_HISTORY_WRITE_ID\"  GROUP BY \"MH_DATABASE\", \"MH_TABLE\") \"hwm\" ON \"cq1\".\"CQ_DATABASE\" = \"hwm\".\"MH_DATABASE\"  AND \"cq1\".\"CQ_TABLE\" = \"hwm\".\"MH_TABLE\"";
            whereClause = whereClause + " AND (\"CQ_HIGHEST_WRITE_ID\" < \"MIN_OPEN_WRITE_ID\" OR \"MIN_OPEN_WRITE_ID\" IS NULL)";
        } else if (this.minOpenTxnWaterMark > 0L) {
            whereClause = whereClause + " AND (\"CQ_NEXT_TXN_ID\" <= " + this.minOpenTxnWaterMark + " OR \"CQ_NEXT_TXN_ID\" IS NULL)";
        }
        queryStr = (String)queryStr + whereClause + " ORDER BY \"CQ_ID\"";
        queryStr = databaseProduct.addLimitClause(this.fetchSize, (String)queryStr);
        return queryStr;
    }

    @Override
    public SqlParameterSource getQueryParameters() {
        return null;
    }

    public List<CompactionInfo> extractData(ResultSet rs) throws SQLException, DataAccessException {
        ArrayList<CompactionInfo> infos = new ArrayList<CompactionInfo>();
        while (rs.next()) {
            CompactionInfo info = new CompactionInfo();
            info.id = rs.getLong(1);
            info.dbname = rs.getString(2);
            info.tableName = rs.getString(3);
            info.partName = rs.getString(4);
            info.type = TxnUtils.dbCompactionType2ThriftType(rs.getString(5).charAt(0));
            info.runAs = rs.getString(6);
            info.highestWriteId = rs.getLong(7);
            info.properties = rs.getString(8);
            info.retryRetention = rs.getInt(9);
            info.nextTxnId = rs.getLong(10);
            if (TxnHandler.ConfVars.useMinHistoryWriteId()) {
                long value = rs.getLong(11);
                info.minOpenWriteId = !rs.wasNull() ? value : Long.MAX_VALUE;
            }
            infos.add(info);
        }
        return infos;
    }
}

