/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.async.methods.SimpleBody;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheContext;
import org.apache.hc.client5.http.cache.HttpCacheEntry;
import org.apache.hc.client5.http.cache.RequestCacheControl;
import org.apache.hc.client5.http.cache.ResourceIOException;
import org.apache.hc.client5.http.cache.ResponseCacheControl;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.impl.ExecSupport;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CacheControlHeaderGenerator;
import org.apache.hc.client5.http.impl.cache.CacheControlHeaderParser;
import org.apache.hc.client5.http.impl.cache.CacheHit;
import org.apache.hc.client5.http.impl.cache.CacheMatch;
import org.apache.hc.client5.http.impl.cache.CacheSuitability;
import org.apache.hc.client5.http.impl.cache.CachingExecBase;
import org.apache.hc.client5.http.impl.cache.CombinedEntity;
import org.apache.hc.client5.http.impl.cache.ConditionalRequestBuilder;
import org.apache.hc.client5.http.impl.cache.DefaultCacheRevalidator;
import org.apache.hc.client5.http.impl.cache.HttpCache;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.validator.ETag;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.net.URIAuthority;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.ByteArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingExec
extends CachingExecBase
implements ExecChainHandler {
    private final HttpCache responseCache;
    private final DefaultCacheRevalidator cacheRevalidator;
    private final ConditionalRequestBuilder<ClassicHttpRequest> conditionalRequestBuilder;
    private static final Logger LOG = LoggerFactory.getLogger(CachingExec.class);

    CachingExec(HttpCache cache, DefaultCacheRevalidator cacheRevalidator, CacheConfig config) {
        super(config);
        this.responseCache = (HttpCache)Args.notNull((Object)cache, (String)"Response cache");
        this.cacheRevalidator = cacheRevalidator;
        this.conditionalRequestBuilder = new ConditionalRequestBuilder(classicHttpRequest -> ClassicRequestBuilder.copy((ClassicHttpRequest)classicHttpRequest).build());
    }

    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)scope, (String)"Scope");
        HttpRoute route = scope.route;
        HttpClientContext context = scope.clientContext;
        URIAuthority authority = request.getAuthority();
        String scheme = request.getScheme();
        HttpHost target = authority != null ? new HttpHost(scheme, (NamedEndpoint)authority) : route.getTargetHost();
        ClassicHttpResponse response = this.doExecute(target, request, scope, chain);
        context.setRequest((HttpRequest)request);
        context.setResponse((HttpResponse)response);
        return response;
    }

    ClassicHttpResponse doExecute(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        CacheHit root;
        RequestCacheControl requestCacheControl;
        String exchangeId = scope.exchangeId;
        HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} request via cache: {} {}", new Object[]{exchangeId, request.getMethod(), request.getRequestUri()});
        }
        context.setCacheResponseStatus(CacheResponseStatus.CACHE_MISS);
        context.setCacheEntry(null);
        if (this.clientRequestsOurOptions((HttpRequest)request)) {
            context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
            return new BasicClassicHttpResponse(501);
        }
        if (request.containsHeader("Cache-Control")) {
            requestCacheControl = CacheControlHeaderParser.INSTANCE.parse((HttpRequest)request);
        } else {
            requestCacheControl = context.getRequestCacheControlOrDefault();
            CacheControlHeaderGenerator.INSTANCE.generate(requestCacheControl, (HttpMessage)request);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Request cache control: {}", (Object)requestCacheControl);
        }
        if (!this.cacheableRequestPolicy.canBeServedFromCache(requestCacheControl, (HttpRequest)request)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} request cannot be served from cache", (Object)exchangeId);
            }
            return this.callBackend(target, request, scope, chain);
        }
        CacheMatch result = this.responseCache.match(target, (HttpRequest)request);
        CacheHit hit = result != null ? result.hit : null;
        CacheHit cacheHit = root = result != null ? result.root : null;
        if (hit == null) {
            return this.handleCacheMiss(requestCacheControl, root, target, request, scope, chain);
        }
        ResponseCacheControl responseCacheControl = CacheControlHeaderParser.INSTANCE.parse(hit.entry);
        context.setResponseCacheControl(responseCacheControl);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} response cache control: {}", (Object)exchangeId, (Object)responseCacheControl);
        }
        return this.handleCacheHit(requestCacheControl, responseCacheControl, hit, target, request, scope, chain);
    }

    private static ClassicHttpResponse convert(SimpleHttpResponse cacheResponse) {
        if (cacheResponse == null) {
            return null;
        }
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(cacheResponse.getCode(), cacheResponse.getReasonPhrase());
        Iterator it = cacheResponse.headerIterator();
        while (it.hasNext()) {
            response.addHeader((Header)it.next());
        }
        response.setVersion((ProtocolVersion)(cacheResponse.getVersion() != null ? cacheResponse.getVersion() : HttpVersion.DEFAULT));
        SimpleBody body = cacheResponse.getBody();
        if (body != null) {
            String contentEncoding;
            ContentType contentType = body.getContentType();
            Header h = response.getFirstHeader("Content-Encoding");
            String string = contentEncoding = h != null ? h.getValue() : null;
            if (body.isText()) {
                response.setEntity((HttpEntity)new StringEntity(body.getBodyText(), contentType, contentEncoding, false));
            } else {
                response.setEntity((HttpEntity)new ByteArrayEntity(body.getBodyBytes(), contentType, contentEncoding, false));
            }
        }
        return response;
    }

    ClassicHttpResponse callBackend(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        String exchangeId = scope.exchangeId;
        Instant requestDate = this.getCurrentDate();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} calling the backend", (Object)exchangeId);
        }
        ClassicHttpResponse backendResponse = chain.proceed(request, scope);
        try {
            return this.handleBackendResponse(target, request, scope, requestDate, this.getCurrentDate(), backendResponse);
        }
        catch (IOException | RuntimeException ex) {
            backendResponse.close();
            throw ex;
        }
    }

    private ClassicHttpResponse handleCacheHit(RequestCacheControl requestCacheControl, ResponseCacheControl responseCacheControl, CacheHit hit, HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        String exchangeId = scope.exchangeId;
        HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} cache hit: {} {}", new Object[]{exchangeId, request.getMethod(), request.getRequestUri()});
        }
        context.setCacheResponseStatus(CacheResponseStatus.CACHE_HIT);
        this.cacheHits.getAndIncrement();
        Instant now = this.getCurrentDate();
        CacheSuitability cacheSuitability = this.suitabilityChecker.assessSuitability(requestCacheControl, responseCacheControl, (HttpRequest)request, hit.entry, now);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} cache suitability: {}", (Object)exchangeId, (Object)cacheSuitability);
        }
        if (cacheSuitability == CacheSuitability.FRESH || cacheSuitability == CacheSuitability.FRESH_ENOUGH) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} cache hit is fresh enough", (Object)exchangeId);
            }
            try {
                SimpleHttpResponse cacheResponse = this.generateCachedResponse((HttpRequest)request, hit.entry, now);
                context.setCacheEntry(hit.entry);
                return CachingExec.convert(cacheResponse);
            }
            catch (ResourceIOException ex) {
                if (requestCacheControl.isOnlyIfCached()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} request marked only-if-cached", (Object)exchangeId);
                    }
                    context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
                    return CachingExec.convert(this.generateGatewayTimeout());
                }
                context.setCacheResponseStatus(CacheResponseStatus.FAILURE);
                return chain.proceed(request, scope);
            }
        }
        if (requestCacheControl.isOnlyIfCached()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} cache entry not is not fresh and only-if-cached requested", (Object)exchangeId);
            }
            context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
            return CachingExec.convert(this.generateGatewayTimeout());
        }
        if (cacheSuitability == CacheSuitability.MISMATCH) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} cache entry does not match the request; calling backend", (Object)exchangeId);
            }
            return this.callBackend(target, request, scope, chain);
        }
        if (request.getEntity() != null && !request.getEntity().isRepeatable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} request is not repeatable; calling backend", (Object)exchangeId);
            }
            return this.callBackend(target, request, scope, chain);
        }
        if (hit.entry.getStatus() == 304 && !this.suitabilityChecker.isConditional((HttpRequest)request)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} non-modified cache entry does not match the non-conditional request; calling backend", (Object)exchangeId);
            }
            return this.callBackend(target, request, scope, chain);
        }
        if (cacheSuitability == CacheSuitability.REVALIDATION_REQUIRED) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} revalidation required; revalidating cache entry", (Object)exchangeId);
            }
            return this.revalidateCacheEntryWithoutFallback(responseCacheControl, hit, target, request, scope, chain);
        }
        if (cacheSuitability == CacheSuitability.STALE_WHILE_REVALIDATED) {
            if (this.cacheRevalidator != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} serving stale with asynchronous revalidation", (Object)exchangeId);
                }
                String revalidationExchangeId = ExecSupport.getNextExchangeId();
                context.setExchangeId(revalidationExchangeId);
                ExecChain.Scope fork = new ExecChain.Scope(revalidationExchangeId, scope.route, scope.originalRequest, scope.execRuntime.fork(null), (HttpClientContext)HttpCacheContext.create());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} starting asynchronous revalidation exchange {}", (Object)exchangeId, (Object)revalidationExchangeId);
                }
                this.cacheRevalidator.revalidateCacheEntry(hit.getEntryKey(), () -> this.revalidateCacheEntry(responseCacheControl, hit, target, request, fork, chain));
                context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
                SimpleHttpResponse cacheResponse = this.responseGenerator.generateResponse((HttpRequest)request, hit.entry);
                context.setCacheEntry(hit.entry);
                return CachingExec.convert(cacheResponse);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} revalidating stale cache entry (asynchronous revalidation disabled)", (Object)exchangeId);
            }
            return this.revalidateCacheEntryWithFallback(requestCacheControl, responseCacheControl, hit, target, request, scope, chain);
        }
        if (cacheSuitability == CacheSuitability.STALE) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} revalidating stale cache entry", (Object)exchangeId);
            }
            return this.revalidateCacheEntryWithFallback(requestCacheControl, responseCacheControl, hit, target, request, scope, chain);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} cache entry not usable; calling backend", (Object)exchangeId);
        }
        return this.callBackend(target, request, scope, chain);
    }

    ClassicHttpResponse revalidateCacheEntry(ResponseCacheControl responseCacheControl, CacheHit hit, HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        Instant requestDate = this.getCurrentDate();
        ClassicHttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequest(responseCacheControl, request, hit.entry);
        ClassicHttpResponse backendResponse = chain.proceed(conditionalRequest, scope);
        try {
            int statusCode;
            Instant responseDate = this.getCurrentDate();
            if (HttpCacheEntry.isNewer(hit.entry, (MessageHeaders)backendResponse)) {
                backendResponse.close();
                ClassicHttpRequest unconditional = this.conditionalRequestBuilder.buildUnconditionalRequest(scope.originalRequest);
                requestDate = this.getCurrentDate();
                backendResponse = chain.proceed(unconditional, scope);
                responseDate = this.getCurrentDate();
            }
            if ((statusCode = backendResponse.getCode()) == 304 || statusCode == 200) {
                context.setCacheResponseStatus(CacheResponseStatus.VALIDATED);
                this.cacheUpdates.getAndIncrement();
            }
            if (statusCode == 304) {
                CacheHit updated = this.responseCache.update(hit, target, (HttpRequest)request, (HttpResponse)backendResponse, requestDate, responseDate);
                SimpleHttpResponse cacheResponse = this.generateCachedResponse((HttpRequest)request, updated.entry, responseDate);
                context.setCacheEntry(updated.entry);
                return CachingExec.convert(cacheResponse);
            }
            return this.handleBackendResponse(target, conditionalRequest, scope, requestDate, responseDate, backendResponse);
        }
        catch (IOException | RuntimeException ex) {
            backendResponse.close();
            throw ex;
        }
    }

    ClassicHttpResponse revalidateCacheEntryWithoutFallback(ResponseCacheControl responseCacheControl, CacheHit hit, HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws HttpException {
        String exchangeId = scope.exchangeId;
        HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        try {
            return this.revalidateCacheEntry(responseCacheControl, hit, target, request, scope, chain);
        }
        catch (IOException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} I/O error while revalidating cache entry", (Object)exchangeId, (Object)ex);
            }
            context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
            return CachingExec.convert(this.generateGatewayTimeout());
        }
    }

    ClassicHttpResponse revalidateCacheEntryWithFallback(RequestCacheControl requestCacheControl, ResponseCacheControl responseCacheControl, CacheHit hit, HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws HttpException, IOException {
        ClassicHttpResponse response;
        String exchangeId = scope.exchangeId;
        HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        try {
            response = this.revalidateCacheEntry(responseCacheControl, hit, target, request, scope, chain);
        }
        catch (IOException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} I/O error while revalidating cache entry", (Object)exchangeId, (Object)ex);
            }
            context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
            if (this.suitabilityChecker.isSuitableIfError(requestCacheControl, responseCacheControl, hit.entry, this.getCurrentDate())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} serving stale response due to IOException and stale-if-error enabled", (Object)exchangeId);
                }
                SimpleHttpResponse cacheResponse = this.responseGenerator.generateResponse((HttpRequest)request, hit.entry);
                context.setCacheEntry(hit.entry);
                return CachingExec.convert(cacheResponse);
            }
            return CachingExec.convert(this.generateGatewayTimeout());
        }
        int status = response.getCode();
        if (this.staleIfErrorAppliesTo(status) && this.suitabilityChecker.isSuitableIfError(requestCacheControl, responseCacheControl, hit.entry, this.getCurrentDate())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} serving stale response due to {} status and stale-if-error enabled", (Object)exchangeId, (Object)status);
            }
            EntityUtils.consume((HttpEntity)response.getEntity());
            context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
            SimpleHttpResponse cacheResponse = this.responseGenerator.generateResponse((HttpRequest)request, hit.entry);
            context.setCacheEntry(hit.entry);
            return CachingExec.convert(cacheResponse);
        }
        return response;
    }

    ClassicHttpResponse handleBackendResponse(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, Instant requestDate, Instant responseDate, ClassicHttpResponse backendResponse) throws IOException {
        String exchangeId = scope.exchangeId;
        this.responseCache.evictInvalidatedEntries(target, (HttpRequest)request, (HttpResponse)backendResponse);
        if (this.isResponseTooBig((EntityDetails)backendResponse.getEntity())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} backend response is known to be too big", (Object)exchangeId);
            }
            return backendResponse;
        }
        HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        ResponseCacheControl responseCacheControl = CacheControlHeaderParser.INSTANCE.parse((HttpResponse)backendResponse);
        context.setResponseCacheControl(responseCacheControl);
        boolean cacheable = this.responseCachingPolicy.isResponseCacheable(responseCacheControl, (HttpRequest)request, (HttpResponse)backendResponse);
        if (cacheable) {
            this.storeRequestIfModifiedSinceFor304Response((HttpRequest)request, (HttpResponse)backendResponse);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} caching backend response", (Object)exchangeId);
            }
            return this.cacheAndReturnResponse(target, (HttpRequest)request, scope, backendResponse, requestDate, responseDate);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} backend response is not cacheable", (Object)exchangeId);
        }
        return backendResponse;
    }

    ClassicHttpResponse cacheAndReturnResponse(HttpHost target, HttpRequest request, ExecChain.Scope scope, ClassicHttpResponse backendResponse, Instant requestSent, Instant responseReceived) throws IOException {
        CacheHit hit;
        ByteArrayBuffer buf;
        HttpEntity entity;
        String exchangeId = scope.exchangeId;
        HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        int statusCode = backendResponse.getCode();
        if (statusCode == 304) {
            CacheHit hit2;
            CacheMatch result = this.responseCache.match(target, request);
            CacheHit cacheHit = hit2 = result != null ? result.hit : null;
            if (hit2 != null) {
                CacheHit updated = this.responseCache.update(hit2, target, request, (HttpResponse)backendResponse, requestSent, responseReceived);
                SimpleHttpResponse cacheResponse = this.responseGenerator.generateResponse(request, updated.entry);
                context.setCacheEntry(hit2.entry);
                return CachingExec.convert(cacheResponse);
            }
        }
        if ((entity = backendResponse.getEntity()) != null) {
            int l;
            buf = new ByteArrayBuffer(1024);
            InputStream inStream = entity.getContent();
            byte[] tmp = new byte[2048];
            long total = 0L;
            while ((l = inStream.read(tmp)) != -1) {
                buf.append(tmp, 0, l);
                if ((total += (long)l) <= this.cacheConfig.getMaxObjectSize()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} backend response content length exceeds maximum", (Object)exchangeId);
                }
                backendResponse.setEntity((HttpEntity)new CombinedEntity(entity, buf));
                return backendResponse;
            }
        } else {
            buf = null;
        }
        backendResponse.close();
        if (this.cacheConfig.isFreshnessCheckEnabled() && statusCode != 304) {
            CacheMatch result = this.responseCache.match(target, request);
            hit = result != null ? result.hit : null;
            if (HttpCacheEntry.isNewer(hit != null ? hit.entry : null, (MessageHeaders)backendResponse)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} backend already contains fresher cache entry", (Object)exchangeId);
                }
            } else {
                hit = this.responseCache.store(target, request, (HttpResponse)backendResponse, buf, requestSent, responseReceived);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} backend response successfully cached", (Object)exchangeId);
                }
            }
        } else {
            hit = this.responseCache.store(target, request, (HttpResponse)backendResponse, buf, requestSent, responseReceived);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} backend response successfully cached (freshness check skipped)", (Object)exchangeId);
            }
        }
        SimpleHttpResponse cacheResponse = this.responseGenerator.generateResponse(request, hit.entry);
        context.setCacheEntry(hit.entry);
        return CachingExec.convert(cacheResponse);
    }

    private ClassicHttpResponse handleCacheMiss(RequestCacheControl requestCacheControl, CacheHit partialMatch, HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        List<CacheHit> variants;
        String exchangeId = scope.exchangeId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} cache miss: {} {}", new Object[]{exchangeId, request.getMethod(), request.getRequestUri()});
        }
        this.cacheMisses.getAndIncrement();
        HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
        if (requestCacheControl.isOnlyIfCached()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} request marked only-if-cached", (Object)exchangeId);
            }
            context.setCacheResponseStatus(CacheResponseStatus.CACHE_MODULE_RESPONSE);
            return CachingExec.convert(this.generateGatewayTimeout());
        }
        if (partialMatch != null && partialMatch.entry.hasVariants() && request.getEntity() == null && (variants = this.responseCache.getVariants(partialMatch)) != null && !variants.isEmpty()) {
            return this.negotiateResponseFromVariants(target, request, scope, chain, variants);
        }
        return this.callBackend(target, request, scope, chain);
    }

    ClassicHttpResponse negotiateResponseFromVariants(HttpHost target, ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain, List<CacheHit> variants) throws IOException, HttpException {
        String exchangeId = scope.exchangeId;
        HashMap<ETag, CacheHit> variantMap = new HashMap<ETag, CacheHit>();
        for (CacheHit variant : variants) {
            ETag eTag = variant.entry.getETag();
            if (eTag == null) continue;
            variantMap.put(eTag, variant);
        }
        ClassicHttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequestFromVariants(request, variantMap.keySet());
        Instant requestDate = this.getCurrentDate();
        ClassicHttpResponse backendResponse = chain.proceed(conditionalRequest, scope);
        try {
            Instant responseDate = this.getCurrentDate();
            if (backendResponse.getCode() != 304) {
                return this.handleBackendResponse(target, request, scope, requestDate, responseDate, backendResponse);
            }
            backendResponse.close();
            ETag resultEtag = ETag.get((MessageHeaders)backendResponse);
            if (resultEtag == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} 304 response did not contain ETag", (Object)exchangeId);
                }
                return this.callBackend(target, request, scope, chain);
            }
            CacheHit match = (CacheHit)variantMap.get(resultEtag);
            if (match == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} 304 response did not contain ETag matching one sent in If-None-Match", (Object)exchangeId);
                }
                return this.callBackend(target, request, scope, chain);
            }
            if (HttpCacheEntry.isNewer(match.entry, (MessageHeaders)backendResponse)) {
                ClassicHttpRequest unconditional = this.conditionalRequestBuilder.buildUnconditionalRequest(request);
                return this.callBackend(target, unconditional, scope, chain);
            }
            HttpCacheContext context = HttpCacheContext.cast((HttpContext)scope.clientContext);
            context.setCacheResponseStatus(CacheResponseStatus.VALIDATED);
            this.cacheUpdates.getAndIncrement();
            CacheHit hit = this.responseCache.storeFromNegotiated(match, target, (HttpRequest)request, (HttpResponse)backendResponse, requestDate, responseDate);
            SimpleHttpResponse cacheResponse = this.generateCachedResponse((HttpRequest)request, hit.entry, responseDate);
            context.setCacheEntry(hit.entry);
            return CachingExec.convert(cacheResponse);
        }
        catch (IOException | RuntimeException ex) {
            backendResponse.close();
            throw ex;
        }
    }
}

