/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.postgis;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.metadata.sql.util.SQLBuilder;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.TableReference;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

final class ExtentEstimator {
    private final Database<?> database;
    private final TableReference table;
    private final Column[] columns;
    private final SQLBuilder builder;
    private GeneralEnvelope envelope;
    private TransformException error;

    ExtentEstimator(Database<?> database, TableReference table, Column[] columns) {
        this.database = database;
        this.table = table;
        this.columns = columns;
        this.builder = new SQLBuilder(database);
    }

    GeneralEnvelope estimate(Statement statement, boolean recall) throws SQLException {
        this.query(statement);
        if (this.envelope == null && !recall) {
            this.builder.append("ANALYZE ").appendIdentifier(this.table.catalog, this.table.schema, this.table.table);
            String sql = this.builder.toString();
            this.builder.clear();
            statement.execute(sql);
            this.query(statement);
        }
        if (this.error != null) {
            this.database.listeners.warning((Exception)this.error);
        }
        return this.envelope;
    }

    private void query(Statement statement) throws SQLException {
        block7: for (Column column : this.columns) {
            if (!column.getGeometryType().isPresent()) continue;
            this.database.appendFunctionCall(this.builder.append("SELECT "), "ST_EstimatedExtent");
            this.builder.append('(');
            if (this.table.schema != null) {
                this.builder.appendValue(this.table.schema).append(", ");
            }
            String sql = this.builder.appendValue(this.table.table).append(", ").appendValue(column.name).append(')').toString();
            this.builder.clear();
            ResultSet result = statement.executeQuery(sql);
            block8: while (true) {
                while (result.next()) {
                    String wkt = result.getString(1);
                    if (wkt == null) continue;
                    GeneralEnvelope env = new GeneralEnvelope((CharSequence)wkt);
                    column.getDefaultCRS().ifPresent(arg_0 -> ((GeneralEnvelope)env).setCoordinateReferenceSystem(arg_0));
                    if (this.envelope == null) {
                        this.envelope = env;
                        continue;
                    }
                    try {
                        this.envelope.add(Envelopes.transform((Envelope)env, (CoordinateReferenceSystem)this.envelope.getCoordinateReferenceSystem()));
                        continue block8;
                    }
                    catch (TransformException e) {
                        if (this.error == null) {
                            this.error = e;
                            continue;
                        }
                        this.error.addSuppressed((Throwable)e);
                    }
                }
                continue block7;
                {
                    continue block8;
                    break;
                }
                break;
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }
    }
}

