/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.quality.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.util.InternationalString;

@XmlType(name="DQM_Description_Type", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0", propOrder={"textDescription", "extendedDescription"})
@XmlRootElement(name="DQM_Description", namespace="http://standards.iso.org/iso/19157/-2/dqm/1.0")
@UML(identifier="DQM_Description", specification=Specification.UNSPECIFIED)
public class DefaultMeasureDescription
extends ISOMetadata {
    private static final long serialVersionUID = 4878784271547209576L;
    private InternationalString textDescription;
    private BrowseGraphic extendedDescription;

    public DefaultMeasureDescription() {
    }

    public DefaultMeasureDescription(CharSequence text) {
        this.textDescription = Types.toInternationalString(text);
    }

    public DefaultMeasureDescription(DefaultMeasureDescription object) {
        super(object);
        if (object != null) {
            this.textDescription = object.getTextDescription();
            this.extendedDescription = object.getExtendedDescription();
        }
    }

    @XmlElement(name="textDescription", required=true)
    @UML(identifier="textDescription", obligation=Obligation.MANDATORY, specification=Specification.UNSPECIFIED)
    public InternationalString getTextDescription() {
        return this.textDescription;
    }

    public void setTextDescription(InternationalString newValue) {
        this.checkWritePermission(this.textDescription);
        this.textDescription = newValue;
    }

    @XmlElement(name="extendedDescription")
    @UML(identifier="extendedDescription", obligation=Obligation.OPTIONAL, specification=Specification.UNSPECIFIED)
    public BrowseGraphic getExtendedDescription() {
        return this.extendedDescription;
    }

    public void setExtendedDescription(BrowseGraphic newValue) {
        this.checkWritePermission(this.extendedDescription);
        this.extendedDescription = newValue;
    }
}

