/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.dem;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.util.GeometryTransformer;

public class ChaikinSmoother
extends GeometryTransformer {
    private final int iterations;
    private final double factor;

    public ChaikinSmoother(int iterations, double factor) {
        this.iterations = iterations;
        this.factor = factor;
    }

    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinateSequence, Geometry parent) {
        return ChaikinSmoother.smooth(coordinateSequence, this.iterations, this.factor);
    }

    public static CoordinateSequence smooth(CoordinateSequence coordinateSequence, int iterations, double factor) {
        if (CoordinateSequences.isRing((CoordinateSequence)coordinateSequence)) {
            return new CoordinateArraySequence(ChaikinSmoother.chaikin(coordinateSequence.toCoordinateArray(), 2, 0.25));
        }
        Coordinate[] original = coordinateSequence.toCoordinateArray();
        Coordinate[] smoothed = ChaikinSmoother.chaikin(original, iterations, factor);
        int sumOfSquares = iterations * (iterations + 1) * (2 * iterations + 1) / 6;
        int trimmedLength = smoothed.length - sumOfSquares;
        Coordinate[] result = new Coordinate[trimmedLength + 2];
        result[0] = original[0];
        System.arraycopy(smoothed, 0, result, 1, trimmedLength);
        result[trimmedLength + 1] = original[original.length - 1];
        return new CoordinateArraySequence(result);
    }

    private static Coordinate[] chaikin(Coordinate[] coordinates, int iterations, double factor) {
        if (iterations <= 0) {
            return coordinates;
        }
        for (int i = 0; i < iterations; ++i) {
            int l = coordinates.length;
            double f1 = 1.0 - factor;
            double f2 = factor;
            Coordinate[] smoothed = new Coordinate[l * 2];
            for (int j = 0; j < l; ++j) {
                Coordinate c1 = coordinates[j];
                Coordinate c2 = coordinates[(j + 1) % l];
                smoothed[j * 2] = new Coordinate(f1 * c1.getX() + f2 * c2.getX(), f1 * c1.getY() + f2 * c2.getY());
                smoothed[j * 2 + 1] = new Coordinate(f2 * c1.getX() + f1 * c2.getX(), f2 * c1.getY() + f1 * c2.getY());
            }
            coordinates = smoothed;
        }
        return coordinates;
    }
}

