/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geoparquet;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;

public record GeoParquetMetadata(@JsonProperty(value="version") String version, @JsonProperty(value="primary_column") String primaryColumn, @JsonProperty(value="columns") Map<String, Column> columns, @JsonProperty(value="encoding") String encoding, @JsonProperty(value="geometry_types") List<String> geometryTypes, @JsonProperty(value="crs") Object crs, @JsonProperty(value="edges") String edges, @JsonProperty(value="bbox") List<Double> bbox, @JsonProperty(value="epoch") String epoch, @JsonProperty(value="covering") Object covering) {
    public int getSrid(String column) {
        Column columnMetadata = this.columns.get(column);
        if (columnMetadata == null || columnMetadata.crs() == null) {
            return 4326;
        }
        JsonNode crsNode = columnMetadata.crs();
        JsonNode idNode = crsNode.get("id");
        if (idNode == null || idNode.get("authority") == null || idNode.get("code") == null) {
            return 4326;
        }
        String authority = idNode.get("authority").asText();
        String code = idNode.get("code").asText();
        if (authority.equals("EPSG")) {
            return this.getEpsgCode(code);
        }
        if (authority.equals("OGC")) {
            return this.getOgcSrid(code);
        }
        return 4326;
    }

    private int getOgcSrid(String code) {
        if ("CRS84".equals(code)) {
            return 4326;
        }
        return 0;
    }

    private int getEpsgCode(String code) {
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public record Column(@JsonProperty(value="encoding") String encoding, @JsonProperty(value="geometry_types") List<String> geometryTypes, @JsonProperty(value="crs") JsonNode crs, @JsonProperty(value="orientation") String orientation, @JsonProperty(value="edges") String edges, @JsonProperty(value="bbox") List<Double> bbox) {
    }
}

