/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.schema.columns;

import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.PreparedDelete;
import com.j256.ormlite.stmt.PreparedUpdate;
import com.j256.ormlite.stmt.UpdateBuilder;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.contents.ContentsDao;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.db.GeoPackageDao;
import mil.nga.geopackage.db.GeoPackageTableCreator;
import mil.nga.geopackage.db.TableColumnKey;
import mil.nga.geopackage.extension.schema.columns.DataColumns;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserColumns;
import mil.nga.geopackage.user.UserTable;

public class DataColumnsDao
extends GeoPackageDao<DataColumns, TableColumnKey> {
    private ContentsDao contentsDao;

    public static DataColumnsDao create(GeoPackageCore geoPackage) {
        return DataColumnsDao.create(geoPackage.getDatabase());
    }

    public static DataColumnsDao create(GeoPackageCoreConnection db) {
        return (DataColumnsDao)((Object)GeoPackageDao.createDao(db, DataColumns.class));
    }

    public DataColumnsDao(ConnectionSource connectionSource, Class<DataColumns> dataClass) throws SQLException {
        super(connectionSource, dataClass);
    }

    public DataColumns queryForId(TableColumnKey key) throws SQLException {
        DataColumns dataColumns = null;
        if (key != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("table_name", key.getTableName());
            fieldValues.put("column_name", key.getColumnName());
            List results = this.queryForFieldValues(fieldValues);
            if (!results.isEmpty()) {
                if (results.size() > 1) {
                    throw new SQLException("More than one " + DataColumns.class.getSimpleName() + " returned for key. Table Name: " + key.getTableName() + ", Column Name: " + key.getColumnName());
                }
                dataColumns = (DataColumns)results.get(0);
            }
        }
        return dataColumns;
    }

    public TableColumnKey extractId(DataColumns data) throws SQLException {
        return data.getId();
    }

    public boolean idExists(TableColumnKey id) throws SQLException {
        return this.queryForId(id) != null;
    }

    public DataColumns queryForSameId(DataColumns data) throws SQLException {
        return this.queryForId(data.getId());
    }

    public int updateId(DataColumns data, TableColumnKey newId) throws SQLException {
        int count = 0;
        DataColumns readData = this.queryForId(data.getId());
        if (readData != null && newId != null) {
            readData.setId(newId);
            count = this.update(readData);
        }
        return count;
    }

    public int delete(DataColumns data) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("table_name", (Object)data.getTableName()).and().eq("column_name", (Object)data.getColumnName());
        PreparedDelete deleteQuery = db.prepare();
        int deleted = this.delete(deleteQuery);
        return deleted;
    }

    public int deleteById(TableColumnKey id) throws SQLException {
        DataColumns dataColumns;
        int count = 0;
        if (id != null && (dataColumns = this.queryForId(id)) != null) {
            count = this.delete(dataColumns);
        }
        return count;
    }

    public int deleteById(String tableName, String columnName) throws SQLException {
        TableColumnKey id = new TableColumnKey(tableName, columnName);
        return this.deleteById(id);
    }

    public int deleteIds(Collection<TableColumnKey> idCollection) throws SQLException {
        int count = 0;
        if (idCollection != null) {
            for (TableColumnKey id : idCollection) {
                count += this.deleteById(id);
            }
        }
        return count;
    }

    public int update(DataColumns dataColumns) throws SQLException {
        UpdateBuilder ub = this.updateBuilder();
        ub.updateColumnValue("name", (Object)dataColumns.getName());
        ub.updateColumnValue("title", (Object)dataColumns.getTitle());
        ub.updateColumnValue("description", (Object)dataColumns.getDescription());
        ub.updateColumnValue("mime_type", (Object)dataColumns.getMimeType());
        ub.updateColumnValue("constraint_name", (Object)dataColumns.getConstraintName());
        ub.where().eq("table_name", (Object)dataColumns.getTableName()).and().eq("column_name", (Object)dataColumns.getColumnName());
        PreparedUpdate update = ub.prepare();
        int updated = this.update(update);
        return updated;
    }

    public List<DataColumns> queryByConstraintName(String constraintName) throws SQLException {
        return this.queryForEq("constraint_name", constraintName);
    }

    public DataColumns getDataColumn(String tableName, String columnName) throws SQLException {
        TableColumnKey id = new TableColumnKey(tableName, columnName);
        return this.queryForId(id);
    }

    public List<DataColumns> queryByTable(String tableName) throws SQLException {
        return this.queryForEq("table_name", tableName);
    }

    public int deleteByTableName(String tableName) throws SQLException {
        DeleteBuilder db = this.deleteBuilder();
        db.where().eq("table_name", (Object)tableName);
        PreparedDelete deleteQuery = db.prepare();
        int deleted = this.delete(deleteQuery);
        return deleted;
    }

    public void saveSchema(UserTable<? extends UserColumn> table) throws SQLException {
        this.saveSchema(table.getUserColumns());
    }

    public void saveSchema(UserColumns<? extends UserColumn> columns) throws SQLException {
        this.saveSchema(columns.getTableName(), columns.getColumns());
    }

    public void saveSchema(String table, List<? extends UserColumn> columns) throws SQLException {
        for (UserColumn userColumn : columns) {
            this.saveSchema(table, userColumn);
        }
    }

    public void saveSchema(String table, UserColumn column) throws SQLException {
        String columnName = column.getName();
        DataColumns schema = column.getSchema();
        DataColumns existing = this.getSchema(table, columnName);
        if (schema != null) {
            schema.setColumnName(columnName);
            if (existing != null) {
                schema.setContents(existing.getContents());
            } else if (schema.getContents() == null) {
                ContentsDao contentsDao = this.getContentsDao();
                Contents contents = contentsDao.queryForId(table);
                schema.setContents(contents);
            }
            if (schema.getContents() != null) {
                if (!this.isTableExists()) {
                    this.getTableCreator().createDataColumns();
                }
                this.createOrUpdate(schema);
            }
        } else if (existing != null) {
            this.deleteById(table, columnName);
        }
    }

    public void loadSchema(UserTable<? extends UserColumn> table) throws SQLException {
        this.loadSchema(table.getUserColumns());
    }

    public void loadSchema(UserColumns<? extends UserColumn> columns) throws SQLException {
        this.loadSchema(columns.getTableName(), columns.getColumns());
    }

    public void loadSchema(String table, List<? extends UserColumn> columns) throws SQLException {
        if (this.isTableExists()) {
            for (UserColumn userColumn : columns) {
                this.loadSchema(table, userColumn);
            }
        }
    }

    public void loadSchema(String table, UserColumn column) throws SQLException {
        column.setSchema(this.getSchema(table, column.getName()));
    }

    public DataColumns getSchema(String table, String column) throws SQLException {
        DataColumns schema = null;
        if (this.isTableExists()) {
            schema = this.getDataColumn(table, column);
        }
        return schema;
    }

    private GeoPackageTableCreator getTableCreator() {
        return new GeoPackageTableCreator(this.db);
    }

    private ContentsDao getContentsDao() {
        if (this.contentsDao == null) {
            this.contentsDao = ContentsDao.create(this.db);
        }
        return this.contentsDao;
    }
}

