/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.utils;

import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;

public class CRSUtils {
    private static final CRSFactory CRS_FACTORY = new CRSFactory();
    private static final CoordinateReferenceSystem WGS_84 = CRS_FACTORY.createFromParameters("WGS 84", new String[]{"+proj=longlat", "+datum=WGS84", "+no_defs"});
    private static final CoordinateReferenceSystem WGS_84_PSEUDO_MERCATOR = CRS_FACTORY.createFromParameters("WGS 84 / Pseudo-Mercator", new String[]{"+proj=merc", "+a=6378137", "+b=6378137", "+lat_ts=0.0", "+lon_0=0.0", "+x_0=0.0", "+y_0=0", "+k=1.0", "+units=m", "+nadgrids=@null", "+wktext", "+no_defs"});

    private CRSUtils() {
    }

    public static CoordinateReferenceSystem createFromSrid(int srid) {
        switch (srid) {
            case 4326: {
                return WGS_84;
            }
            case 3857: {
                return WGS_84_PSEUDO_MERCATOR;
            }
        }
        return CRS_FACTORY.createFromName(String.format("EPSG:%s", srid));
    }
}

