/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.geojson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import mil.nga.sf.Curve;
import mil.nga.sf.Geometry;
import mil.nga.sf.LineString;
import mil.nga.sf.LinearRing;
import mil.nga.sf.geojson.GeometryType;
import mil.nga.sf.geojson.Position;

public class Polygon
extends mil.nga.sf.geojson.Geometry {
    private static final long serialVersionUID = 2L;
    private List<mil.nga.sf.geojson.LineString> rings = null;

    public static Polygon fromCoordinates(List<List<Position>> coordinates) {
        Polygon polygon = new Polygon();
        polygon.setCoordinates(coordinates);
        return polygon;
    }

    public Polygon() {
    }

    public Polygon(List<mil.nga.sf.geojson.LineString> rings) {
        this.rings = rings;
    }

    public Polygon(mil.nga.sf.Polygon polygon) {
        this.setPolygon(polygon);
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.POLYGON;
    }

    @Override
    public Geometry getGeometry() {
        return this.getPolygon();
    }

    public List<List<Position>> getCoordinates() {
        ArrayList<List<Position>> coordinates = new ArrayList<List<Position>>();
        for (mil.nga.sf.geojson.LineString ring : this.rings) {
            coordinates.add(ring.getCoordinates());
        }
        return coordinates;
    }

    public void setCoordinates(List<List<Position>> coordinates) {
        this.rings = new ArrayList<mil.nga.sf.geojson.LineString>();
        for (List<Position> positions : coordinates) {
            this.rings.add(mil.nga.sf.geojson.LineString.fromCoordinates(positions));
        }
    }

    @JsonIgnore
    public List<mil.nga.sf.geojson.LineString> getRings() {
        return this.rings;
    }

    public void setRings(List<mil.nga.sf.geojson.LineString> rings) {
        this.rings = rings;
    }

    @JsonIgnore
    public mil.nga.sf.Polygon getPolygon() {
        mil.nga.sf.Polygon polygon = new mil.nga.sf.Polygon();
        for (mil.nga.sf.geojson.LineString ring : this.rings) {
            polygon.addRing((Curve)new LinearRing(ring.getLineString().getPoints()));
        }
        return polygon;
    }

    public void setPolygon(mil.nga.sf.Polygon polygon) {
        this.rings = new ArrayList<mil.nga.sf.geojson.LineString>();
        for (LineString ring : polygon.getRings()) {
            this.rings.add(new mil.nga.sf.geojson.LineString(ring));
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.rings == null ? 0 : this.rings.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Polygon other = (Polygon)obj;
        return !(this.rings == null ? other.rings != null : !this.rings.equals(other.rings));
    }
}

