/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.baremaps.tilestore.TileCoord;
import org.locationtech.jts.geom.Envelope;

class TileCoordIterator
implements Iterator<TileCoord> {
    private final Envelope envelope;
    private final int minZoom;
    private final int maxZoom;
    private int z;
    private int x;
    private int y;

    public TileCoordIterator(Envelope envelope, int minZoom, int maxZoom) {
        this.envelope = envelope;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.z = this.minZoom;
        TileCoord min = TileCoord.min(envelope, this.z);
        this.x = min.x();
        this.y = min.y();
    }

    @Override
    public boolean hasNext() {
        TileCoord max = TileCoord.max(this.envelope, this.z);
        return this.x <= max.x() && this.y <= max.y() && this.z <= this.maxZoom;
    }

    @Override
    public TileCoord next() {
        TileCoord tileCoord = new TileCoord(this.x, this.y, this.z);
        TileCoord max = TileCoord.max(this.envelope, this.z);
        if (this.z > max.z()) {
            throw new NoSuchElementException();
        }
        if (this.x < max.x()) {
            ++this.x;
        } else if (this.y < max.y()) {
            ++this.y;
            TileCoord min = TileCoord.min(this.envelope, this.z);
            this.x = min.x();
        } else {
            ++this.z;
            TileCoord min = TileCoord.min(this.envelope, this.z);
            this.x = min.x();
            this.y = min.y();
        }
        return tileCoord;
    }
}

