/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.baremaps.data.collection.AppendOnlyLog;
import org.apache.baremaps.data.collection.DataConversions;
import org.apache.baremaps.data.collection.DataList;
import org.apache.baremaps.data.collection.DataMap;
import org.apache.baremaps.data.collection.MemoryAlignedDataList;
import org.apache.baremaps.data.collection.MemoryAlignedDataMap;
import org.apache.baremaps.data.collection.MonotonicDataMap;
import org.apache.baremaps.data.collection.MonotonicPairedDataMap;
import org.apache.baremaps.data.memory.Memory;
import org.apache.baremaps.data.memory.MemoryMappedDirectory;
import org.apache.baremaps.data.type.DataType;
import org.apache.baremaps.data.type.FixedSizeDataType;
import org.apache.baremaps.data.type.LonLatDataType;
import org.apache.baremaps.data.type.LongDataType;
import org.apache.baremaps.data.type.LongListDataType;
import org.apache.baremaps.data.type.PairDataType;
import org.apache.baremaps.postgres.utils.PostgresUtils;
import org.apache.baremaps.utils.FileUtils;
import org.locationtech.jts.geom.Coordinate;

public class WorkflowContext {
    private final Path dataDir;
    private final Path cacheDir;
    private Map<Object, DataSource> dataSources = new ConcurrentHashMap<Object, DataSource>();

    public WorkflowContext() {
        this(Paths.get("./data", new String[0]), Paths.get("./cache", new String[0]));
    }

    public WorkflowContext(Path dataDir, Path cacheDir) {
        this.dataDir = dataDir;
        this.cacheDir = cacheDir;
    }

    public DataSource getDataSource(Object database) {
        return this.dataSources.computeIfAbsent(database, PostgresUtils::createDataSourceFromObject);
    }

    public Map<Long, Coordinate> getCoordinateMap() throws IOException {
        return DataConversions.asMap(this.getMonotonicPairedDataMap("coordinates", (DataType<Coordinate>)new LonLatDataType()));
    }

    public Map<Long, List<Long>> getReferenceMap() throws IOException {
        return DataConversions.asMap(this.getMonotonicDataMap("references", (DataType)new LongListDataType()));
    }

    private <T> DataMap<Long, T> getMemoryAlignedDataMap(String name, FixedSizeDataType<T> dataType) throws IOException {
        Path coordinateDir = Files.createDirectories(this.cacheDir.resolve(name), new FileAttribute[0]);
        return new MemoryAlignedDataMap(dataType, (Memory)new MemoryMappedDirectory(coordinateDir));
    }

    private <T> DataMap<Long, T> getMonotonicDataMap(String name, DataType<T> dataType) throws IOException {
        Path mapDir = Files.createDirectories(this.cacheDir.resolve(name), new FileAttribute[0]);
        Path keysDir = Files.createDirectories(mapDir.resolve("keys"), new FileAttribute[0]);
        Path valuesDir = Files.createDirectories(mapDir.resolve("values"), new FileAttribute[0]);
        return new MonotonicDataMap((DataList)new MemoryAlignedDataList((FixedSizeDataType)new PairDataType((FixedSizeDataType)new LongDataType(), (FixedSizeDataType)new LongDataType()), (Memory)new MemoryMappedDirectory(keysDir)), new AppendOnlyLog(dataType, (Memory)new MemoryMappedDirectory(valuesDir)));
    }

    private DataMap<Long, Coordinate> getMonotonicPairedDataMap(String name, DataType<Coordinate> dataType) throws IOException {
        Path mapDir = Files.createDirectories(this.cacheDir.resolve(name), new FileAttribute[0]);
        return new MonotonicPairedDataMap(new MemoryAlignedDataList((FixedSizeDataType)new PairDataType((FixedSizeDataType)new LongDataType(), (FixedSizeDataType)new LonLatDataType()), (Memory)new MemoryMappedDirectory(Files.createDirectories(mapDir, new FileAttribute[0]))));
    }

    public void cleanCache() throws IOException {
        FileUtils.deleteRecursively(this.cacheDir);
    }

    public void cleanData() throws IOException {
        FileUtils.deleteRecursively(this.dataDir);
    }
}

