/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.sf.util.sweep;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mil.nga.sf.LineString;
import mil.nga.sf.Point;
import mil.nga.sf.util.sweep.Event;
import mil.nga.sf.util.sweep.EventType;
import mil.nga.sf.util.sweep.SweepLine;

public class EventQueue
implements Iterable<Event> {
    private List<Event> events = new ArrayList<Event>();

    public EventQueue(LineString ring) {
        this.addRing(ring, 0);
        this.sort();
    }

    public EventQueue(List<LineString> rings) {
        for (int i = 0; i < rings.size(); ++i) {
            LineString ring = rings.get(i);
            this.addRing(ring, i);
        }
        this.sort();
    }

    private void addRing(LineString ring, int ringIndex) {
        List<Point> points = ring.getPoints();
        for (int i = 0; i < points.size(); ++i) {
            Point point1 = points.get(i);
            Point point2 = points.get((i + 1) % points.size());
            EventType type1 = null;
            EventType type2 = null;
            if (SweepLine.xyOrder(point1, point2) < 0) {
                type1 = EventType.LEFT;
                type2 = EventType.RIGHT;
            } else {
                type1 = EventType.RIGHT;
                type2 = EventType.LEFT;
            }
            Event endpoint1 = new Event(i, ringIndex, point1, type1);
            Event endpoint2 = new Event(i, ringIndex, point2, type2);
            this.events.add(endpoint1);
            this.events.add(endpoint2);
        }
    }

    private void sort() {
        Collections.sort(this.events);
    }

    @Override
    public Iterator<Event> iterator() {
        return this.events.iterator();
    }
}

