/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.Strings;

public class ConfigurationProcessor {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ConfigurableInstanceFactory instanceFactory;
    private final ThreadLocal<Node> currentNode = new ThreadLocal();

    public ConfigurationProcessor(ConfigurableInstanceFactory instanceFactory) {
        instanceFactory.registerBinding(Node.CURRENT_NODE, this.currentNode::get);
        this.instanceFactory = instanceFactory;
    }

    public <T> T processNodeTree(Node node) {
        PluginType type = node.getType();
        if (type != null && type.isDeferChildren()) {
            LOGGER.debug("Deferring configuration of child nodes of {}", (Object)node.getName());
            node.setObject(this.withNode(node, this::instantiate));
        } else {
            LOGGER.debug("Configuring child nodes of {}", (Object)node.getName());
            node.getChildren().forEach(child -> child.setObject(this.withNode((Node)child, this::processNodeTree)));
            if (type == null) {
                if (node.getParent() == null) {
                    LOGGER.error("Unable to locate plugin for node {}", (Object)node.getName());
                }
            } else {
                LOGGER.debug("Configured child nodes of {}", (Object)node.getName());
                node.setObject(this.withNode(node, this::instantiate));
            }
        }
        ConfigurationProcessor.verifyAttributesConsumed(node);
        ConfigurationProcessor.verifyChildrenConsumed(node);
        return (T)node.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withNode(Node node, Function<Node, T> function) {
        this.currentNode.set(node);
        try {
            T t = function.apply(node);
            return t;
        }
        finally {
            this.currentNode.remove();
        }
    }

    private Object instantiate(Node node) {
        PluginType type = node.getType();
        Class pluginClass = type.getPluginClass();
        List children = node.getChildren();
        if (Map.class.isAssignableFrom(pluginClass)) {
            LOGGER.debug("Instantiating Map of child nodes of {}", (Object)node.getName());
            return children.stream().collect(Collectors.toMap(Node::getName, Node::getObject));
        }
        if (Collection.class.isAssignableFrom(pluginClass)) {
            LOGGER.debug("Instantiating List of child nodes of {}", (Object)node.getName());
            return children.stream().map(Node::getObject).collect(Collectors.toList());
        }
        try {
            Key key = Key.builder((Class)pluginClass).setNamespace(type.getNamespace()).setName(type.getName()).get();
            return this.instanceFactory.getInstance(key);
        }
        catch (Throwable e) {
            LOGGER.error("Could not configure plugin element {}: {}", (Object)node.getName(), (Object)e.toString(), (Object)e);
            return null;
        }
    }

    private static void verifyAttributesConsumed(Node node) {
        Map attrs = node.getAttributes();
        if (!attrs.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String key : attrs.keySet()) {
                if (sb.length() == 0) {
                    sb.append(node.getName());
                    sb.append(" contains ");
                    if (attrs.size() == 1) {
                        sb.append("an invalid element or attribute ");
                    } else {
                        sb.append("invalid attributes ");
                    }
                } else {
                    sb.append(", ");
                }
                StringBuilders.appendDqValue((StringBuilder)sb, (Object)key);
            }
            LOGGER.error(sb.toString());
        }
    }

    private static void verifyChildrenConsumed(Node node) {
        PluginType type = node.getType();
        if (type != null && !type.isDeferChildren() && node.hasChildren()) {
            for (Node child : node.getChildren()) {
                String name;
                String nodeType = node.getType().getElementType();
                String context = nodeType.equalsIgnoreCase(name = node.getName()) || Strings.isBlank((String)nodeType) ? name : nodeType + " " + name;
                LOGGER.error("{} has no field or parameter that matches element {}", (Object)context, (Object)child.getName());
            }
        }
    }
}

