/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jul;

import org.apache.logging.log4j.spi.PropertyComponent;
import org.apache.logging.log4j.util.PropertyKey;

public enum JulPropertyKey implements PropertyKey
{
    LEVEL_CONVERTER(PropertyComponent.JUL, "levelConverter"),
    LOGGER_ADAPTER(PropertyComponent.JUL, "loggerAdpater");

    private final PropertyComponent component;
    private final String name;
    private final String key;
    private final String systemKey;

    private JulPropertyKey(PropertyComponent component, String name) {
        this.component = component;
        this.name = name;
        this.key = component.getName() + "." + name;
        this.systemKey = "log4j2.*." + this.key;
    }

    public static PropertyKey findKey(String component, String name) {
        for (JulPropertyKey key : JulPropertyKey.values()) {
            if (!key.getComponent().equals(component) || !key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    public String getComponent() {
        return this.component.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getSystemKey() {
        return this.systemKey;
    }

    public String toString() {
        return this.getKey();
    }
}

