/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.shortcircuit;

import java.io.FileInputStream;
import java.io.IOException;
import org.apache.hadoop.hdfs.net.DomainPeer;
import org.apache.hadoop.hdfs.shortcircuit.DfsClientShmManager;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.DomainSocketWatcher;
import org.apache.hadoop.util.Preconditions;

public class DfsClientShm
extends ShortCircuitShm
implements DomainSocketWatcher.Handler {
    private final DfsClientShmManager.EndpointShmManager manager;
    private final DomainPeer peer;
    private boolean disconnected = false;

    DfsClientShm(ShortCircuitShm.ShmId shmId, FileInputStream stream, DfsClientShmManager.EndpointShmManager manager, DomainPeer peer) throws IOException {
        super(shmId, stream);
        this.manager = manager;
        this.peer = peer;
    }

    public DfsClientShmManager.EndpointShmManager getEndpointShmManager() {
        return this.manager;
    }

    public DomainPeer getPeer() {
        return this.peer;
    }

    public synchronized boolean isDisconnected() {
        return this.disconnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(DomainSocket sock) {
        this.manager.unregisterShm(this.getShmId());
        DfsClientShm dfsClientShm = this;
        synchronized (dfsClientShm) {
            Preconditions.checkState((!this.disconnected ? 1 : 0) != 0);
            this.disconnected = true;
            boolean hadSlots = false;
            ShortCircuitShm.SlotIterator iter = this.slotIterator();
            while (iter.hasNext()) {
                ShortCircuitShm.Slot slot = (ShortCircuitShm.Slot)iter.next();
                slot.makeInvalid();
                hadSlots = true;
            }
            if (!hadSlots) {
                this.free();
            }
        }
        return true;
    }
}

