/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateGenerator;

public class SelfSignedHttpsCertificateBuilder {
    private static final String SA_SHA256_RSA = "SHA256withRSA";
    private final HttpsCertificateGenerator generator = new HttpsCertificateGenerator();
    private Period validityPeriod = Period.ofYears(3);
    private String commonName;
    private List<String> dnsNames = new ArrayList<String>();
    private List<String> ipAddresses = new ArrayList<String>();
    private final KeyPair keyPair;

    public SelfSignedHttpsCertificateBuilder(KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public SelfSignedHttpsCertificateBuilder setValidityPeriod(Period validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }

    public SelfSignedHttpsCertificateBuilder setCommonName(String commonName) {
        this.commonName = commonName;
        return this;
    }

    public SelfSignedHttpsCertificateBuilder addDnsName(String dnsName) {
        this.dnsNames.add(dnsName);
        return this;
    }

    public SelfSignedHttpsCertificateBuilder addIpAddress(String ipAddress) {
        this.ipAddresses.add(ipAddress);
        return this;
    }

    public X509Certificate build() throws Exception {
        LocalDate now = LocalDate.now();
        LocalDate expiration = now.plus(this.validityPeriod);
        Date notBefore = Date.from(now.atStartOfDay(ZoneId.systemDefault()).toInstant());
        Date notAfter = Date.from(expiration.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return this.generator.generateSelfSigned(this.keyPair, notBefore, notAfter, this.commonName, null, null, null, null, null, null, this.dnsNames, this.ipAddresses, SA_SHA256_RSA);
    }

    private static class HttpsCertificateGenerator
    extends SelfSignedCertificateGenerator {
        private HttpsCertificateGenerator() {
        }

        @Override
        protected void addKeyUsage(X509v3CertificateBuilder certificateBuilder) {
        }

        @Override
        protected void addExtendedKeyUsage(X509v3CertificateBuilder certificateBuilder) {
        }
    }
}

