/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator;

import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionScheduleContext;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionEstimateUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskInfo;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.CompactionTaskMetadataInfo;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;

public class ReadChunkInnerCompactionEstimator
extends AbstractInnerSpaceEstimator {
    @Override
    public long calculatingMetadataMemoryCost(CompactionTaskInfo taskInfo) {
        long cost = 0L;
        long maxAlignedSeriesMemCost = taskInfo.getFileInfoList().stream().mapToLong(fileInfo -> fileInfo.maxMemToReadAlignedSeries).sum();
        long maxNonAlignedSeriesMemCost = taskInfo.getFileInfoList().stream().mapToLong(fileInfo -> fileInfo.maxMemToReadNonAlignedSeries).sum();
        cost += Math.min(Math.max(maxAlignedSeriesMemCost, maxNonAlignedSeriesMemCost), (long)(taskInfo.getFileInfoList().size() * taskInfo.getMaxChunkMetadataNumInDevice()) * taskInfo.getMaxChunkMetadataSize());
        return cost += this.fixedMemoryBudget;
    }

    @Override
    public long calculatingDataMemoryCost(CompactionTaskInfo taskInfo) {
        if (taskInfo.getTotalChunkNum() == 0L) {
            return taskInfo.getModificationFileSize();
        }
        long averageChunkSize = taskInfo.getTotalFileSize() / taskInfo.getTotalChunkNum();
        int batchSize = this.config.getCompactionMaxAlignedSeriesNumInOneBatch();
        int maxConcurrentSeriesNum = Math.min(batchSize <= 0 ? Integer.MAX_VALUE : batchSize, taskInfo.getMaxConcurrentSeriesNum());
        long maxConcurrentSeriesSizeOfTotalFiles = averageChunkSize * (long)taskInfo.getFileInfoList().size() * (long)maxConcurrentSeriesNum * (long)taskInfo.getMaxChunkMetadataNumInSeries() + (long)(maxConcurrentSeriesNum * this.tsFileConfig.getPageSizeInByte());
        long maxTargetChunkWriterSize = this.config.getTargetChunkSize() * (long)maxConcurrentSeriesNum;
        long targetChunkWriterSize = Math.min(maxConcurrentSeriesSizeOfTotalFiles, maxTargetChunkWriterSize);
        long chunkSizeFromSourceFile = (averageChunkSize + (long)this.tsFileConfig.getPageSizeInByte()) * (long)maxConcurrentSeriesNum;
        return targetChunkWriterSize + chunkSizeFromSourceFile + taskInfo.getModificationFileSize();
    }

    @Override
    public long roughEstimateInnerCompactionMemory(CompactionScheduleContext context, List<TsFileResource> resources) {
        if (this.config.getCompactionMaxAlignedSeriesNumInOneBatch() <= 0) {
            return -1L;
        }
        CompactionTaskMetadataInfo metadataInfo = CompactionEstimateUtils.collectMetadataInfoFromCachedFileInfo(resources, this.roughInfoMap, false);
        int maxConcurrentSeriesNum = metadataInfo.getMaxConcurrentSeriesNum(false);
        long maxChunkSize = this.config.getTargetChunkSize();
        long maxPageSize = this.tsFileConfig.getPageSizeInByte();
        return (long)(2 * maxConcurrentSeriesNum) * (maxChunkSize + maxPageSize) + this.fixedMemoryBudget + metadataInfo.metadataMemCost;
    }
}

