/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.node;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.TwoChildProcessNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.ComparisonExpression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class JoinNode
extends TwoChildProcessNode {
    private final JoinType joinType;
    private final List<EquiJoinClause> criteria;
    private final Optional<AsofJoinClause> asofCriteria;
    private final List<Symbol> leftOutputSymbols;
    private final List<Symbol> rightOutputSymbols;
    private final Optional<Expression> filter;
    private final Optional<Boolean> spillable;

    public JoinNode(PlanNodeId id, JoinType joinType, PlanNode leftChild, PlanNode rightChild, List<EquiJoinClause> criteria, Optional<AsofJoinClause> asofCriteria, List<Symbol> leftOutputSymbols, List<Symbol> rightOutputSymbols, Optional<Expression> filter, Optional<Boolean> spillable) {
        super(id);
        Objects.requireNonNull(joinType, "type is null");
        Objects.requireNonNull(leftChild, "left is null");
        Objects.requireNonNull(rightChild, "right is null");
        Objects.requireNonNull(criteria, "criteria is null");
        Objects.requireNonNull(leftOutputSymbols, "leftOutputSymbols is null");
        Objects.requireNonNull(rightOutputSymbols, "rightOutputSymbols is null");
        Objects.requireNonNull(filter, "filter is null");
        Preconditions.checkArgument((!filter.isPresent() || !(filter.get() instanceof NullLiteral) ? 1 : 0) != 0, (String)"Filter must be an expression of boolean type: %s", filter);
        Objects.requireNonNull(spillable, "spillable is null");
        this.joinType = joinType;
        this.leftChild = leftChild;
        this.rightChild = rightChild;
        this.criteria = ImmutableList.copyOf(criteria);
        this.asofCriteria = asofCriteria;
        this.leftOutputSymbols = ImmutableList.copyOf(leftOutputSymbols);
        this.rightOutputSymbols = ImmutableList.copyOf(rightOutputSymbols);
        this.filter = filter;
        this.spillable = spillable;
        ImmutableSet leftSymbols = ImmutableSet.copyOf(leftChild.getOutputSymbols());
        ImmutableSet rightSymbols = ImmutableSet.copyOf(rightChild.getOutputSymbols());
        Preconditions.checkArgument((boolean)leftSymbols.containsAll(leftOutputSymbols), (Object)"Left source inputs do not contain all left output symbols");
        Preconditions.checkArgument((boolean)rightSymbols.containsAll(rightOutputSymbols), (Object)"Right source inputs do not contain all right output symbols");
        criteria.forEach(arg_0 -> JoinNode.lambda$new$0((Set)leftSymbols, (Set)rightSymbols, arg_0));
    }

    public JoinNode(PlanNodeId id, JoinType joinType, List<EquiJoinClause> criteria, Optional<AsofJoinClause> asofCriteria, List<Symbol> leftOutputSymbols, List<Symbol> rightOutputSymbols) {
        super(id);
        Objects.requireNonNull(joinType, "type is null");
        Objects.requireNonNull(criteria, "criteria is null");
        this.leftOutputSymbols = leftOutputSymbols;
        this.rightOutputSymbols = rightOutputSymbols;
        this.filter = Optional.empty();
        this.spillable = Optional.empty();
        this.joinType = joinType;
        this.criteria = criteria;
        this.asofCriteria = asofCriteria;
    }

    public JoinNode flip() {
        return new JoinNode(this.id, this.joinType.flip(), this.rightChild, this.leftChild, EquiJoinClause.flipBatch(this.criteria), this.asofCriteria, this.rightOutputSymbols, this.leftOutputSymbols, this.filter, this.spillable);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitJoin(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes for JoinNode");
        return new JoinNode(this.getPlanNodeId(), this.joinType, newChildren.get(0), newChildren.get(1), this.criteria, this.asofCriteria, this.leftOutputSymbols, this.rightOutputSymbols, this.filter, this.spillable);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.leftOutputSymbols).addAll(this.rightOutputSymbols).build();
    }

    @Override
    public PlanNode clone() {
        JoinNode joinNode = new JoinNode(this.getPlanNodeId(), this.joinType, this.getLeftChild(), this.getRightChild(), this.criteria, this.asofCriteria, this.leftOutputSymbols, this.rightOutputSymbols, this.filter, this.spillable);
        joinNode.setLeftChild(null);
        joinNode.setRightChild(null);
        return joinNode;
    }

    @Override
    public List<String> getOutputColumnNames() {
        throw new IllegalStateException();
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.TABLE_JOIN_NODE.serialize(byteBuffer);
        ReadWriteIOUtils.write((int)this.joinType.ordinal(), (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.criteria.size(), (ByteBuffer)byteBuffer);
        for (EquiJoinClause equiJoinClause : this.criteria) {
            Symbol.serialize(equiJoinClause.getLeft(), byteBuffer);
            Symbol.serialize(equiJoinClause.getRight(), byteBuffer);
        }
        if (this.asofCriteria.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (ByteBuffer)byteBuffer);
            AsofJoinClause asofJoinClause = this.asofCriteria.get();
            ReadWriteIOUtils.write((int)asofJoinClause.getOperator().ordinal(), (ByteBuffer)byteBuffer);
            Symbol.serialize(asofJoinClause.getLeft(), byteBuffer);
            Symbol.serialize(asofJoinClause.getRight(), byteBuffer);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.leftOutputSymbols.size(), (ByteBuffer)byteBuffer);
        for (Symbol leftOutputSymbol : this.leftOutputSymbols) {
            Symbol.serialize(leftOutputSymbol, byteBuffer);
        }
        ReadWriteIOUtils.write((int)this.rightOutputSymbols.size(), (ByteBuffer)byteBuffer);
        for (Symbol rightOutputSymbol : this.rightOutputSymbols) {
            Symbol.serialize(rightOutputSymbol, byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.TABLE_JOIN_NODE.serialize(stream);
        ReadWriteIOUtils.write((int)this.joinType.ordinal(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.criteria.size(), (OutputStream)stream);
        for (EquiJoinClause equiJoinClause : this.criteria) {
            Symbol.serialize(equiJoinClause.getLeft(), stream);
            Symbol.serialize(equiJoinClause.getRight(), stream);
        }
        if (this.asofCriteria.isPresent()) {
            ReadWriteIOUtils.write((Boolean)true, (OutputStream)stream);
            AsofJoinClause asofJoinClause = this.asofCriteria.get();
            ReadWriteIOUtils.write((int)asofJoinClause.getOperator().ordinal(), (OutputStream)stream);
            Symbol.serialize(asofJoinClause.getLeft(), stream);
            Symbol.serialize(asofJoinClause.getRight(), stream);
        } else {
            ReadWriteIOUtils.write((Boolean)false, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((int)this.leftOutputSymbols.size(), (OutputStream)stream);
        for (Symbol leftOutputSymbol : this.leftOutputSymbols) {
            Symbol.serialize(leftOutputSymbol, stream);
        }
        ReadWriteIOUtils.write((int)this.rightOutputSymbols.size(), (OutputStream)stream);
        for (Symbol rightOutputSymbol : this.rightOutputSymbols) {
            Symbol.serialize(rightOutputSymbol, stream);
        }
    }

    public static JoinNode deserialize(ByteBuffer byteBuffer) {
        JoinType joinType = JoinType.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<EquiJoinClause> criteria = new ArrayList<EquiJoinClause>(size);
        while (size-- > 0) {
            criteria.add(new EquiJoinClause(Symbol.deserialize(byteBuffer), Symbol.deserialize(byteBuffer)));
        }
        Optional<AsofJoinClause> asofJoinClause = Optional.empty();
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            asofJoinClause = Optional.of(new AsofJoinClause(ComparisonExpression.Operator.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)], Symbol.deserialize(byteBuffer), Symbol.deserialize(byteBuffer)));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> leftOutputSymbols = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            leftOutputSymbols.add(Symbol.deserialize(byteBuffer));
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Symbol> rightOutputSymbols = new ArrayList<Symbol>(size);
        while (size-- > 0) {
            rightOutputSymbols.add(Symbol.deserialize(byteBuffer));
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        return new JoinNode(planNodeId, joinType, criteria, asofJoinClause, leftOutputSymbols, rightOutputSymbols);
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public List<EquiJoinClause> getCriteria() {
        return this.criteria;
    }

    public Optional<AsofJoinClause> getAsofCriteria() {
        return this.asofCriteria;
    }

    public List<Symbol> getLeftOutputSymbols() {
        return this.leftOutputSymbols;
    }

    public List<Symbol> getRightOutputSymbols() {
        return this.rightOutputSymbols;
    }

    public Optional<Expression> getFilter() {
        return this.filter;
    }

    public Optional<Boolean> isSpillable() {
        return this.spillable;
    }

    public boolean isCrossJoin() {
        return !this.asofCriteria.isPresent() && this.criteria.isEmpty() && !this.filter.isPresent() && this.joinType == JoinType.INNER;
    }

    public String toString() {
        return "JoinNode-" + this.getPlanNodeId();
    }

    private static /* synthetic */ void lambda$new$0(Set leftSymbols, Set rightSymbols, EquiJoinClause equiJoinClause) {
        Preconditions.checkArgument((leftSymbols.contains(equiJoinClause.getLeft()) && rightSymbols.contains(equiJoinClause.getRight()) ? 1 : 0) != 0, (String)"Equality join criteria should be normalized according to join sides: %s", (Object)equiJoinClause);
    }

    public static enum JoinType {
        INNER("InnerJoin"),
        LEFT("LeftJoin"),
        RIGHT("RightJoin"),
        FULL("FullJoin");

        private final String joinLabel;

        private JoinType(String joinLabel) {
            this.joinLabel = joinLabel;
        }

        public String getJoinLabel() {
            return this.joinLabel;
        }

        public JoinType flip() {
            switch (this) {
                case INNER: {
                    return INNER;
                }
                case FULL: {
                    return FULL;
                }
                case LEFT: {
                    return RIGHT;
                }
                case RIGHT: {
                    return LEFT;
                }
            }
            throw new IllegalArgumentException("Unsupported join type: " + (Object)((Object)this));
        }
    }

    public static class EquiJoinClause {
        private final Symbol left;
        private final Symbol right;

        public EquiJoinClause(Symbol left, Symbol right) {
            this.left = Objects.requireNonNull(left, "left is null");
            this.right = Objects.requireNonNull(right, "right is null");
        }

        public Symbol getLeft() {
            return this.left;
        }

        public Symbol getRight() {
            return this.right;
        }

        public ComparisonExpression toExpression() {
            return new ComparisonExpression(ComparisonExpression.Operator.EQUAL, this.left.toSymbolReference(), this.right.toSymbolReference());
        }

        public EquiJoinClause flip() {
            return new EquiJoinClause(this.right, this.left);
        }

        public static List<EquiJoinClause> flipBatch(List<EquiJoinClause> input) {
            ImmutableList.Builder builder = ImmutableList.builder();
            input.forEach(clause -> builder.add((Object)clause.flip()));
            return builder.build();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            EquiJoinClause other = (EquiJoinClause)obj;
            return Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
        }

        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public String toString() {
            return String.format("%s = %s", this.left, this.right);
        }
    }

    public static class AsofJoinClause {
        private final Symbol left;
        private final Symbol right;
        private final ComparisonExpression.Operator operator;

        public AsofJoinClause(ComparisonExpression.Operator operator, Symbol left, Symbol right) {
            this.operator = operator;
            this.left = Objects.requireNonNull(left, "left is null");
            this.right = Objects.requireNonNull(right, "right is null");
        }

        public Symbol getLeft() {
            return this.left;
        }

        public Symbol getRight() {
            return this.right;
        }

        public ComparisonExpression.Operator getOperator() {
            return this.operator;
        }

        public ComparisonExpression toExpression() {
            return new ComparisonExpression(this.operator, this.left.toSymbolReference(), this.right.toSymbolReference());
        }

        public AsofJoinClause flip() {
            return new AsofJoinClause(this.operator.flip(), this.right, this.left);
        }

        public boolean isOperatorContainsGreater() {
            switch (this.operator) {
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    return true;
                }
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: {
                    return false;
                }
            }
            throw new IllegalArgumentException("Invalid operator type: " + (Object)((Object)this.operator));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            AsofJoinClause other = (AsofJoinClause)obj;
            return Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.left, other.left) && Objects.equals(this.right, other.right);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.operator, this.left, this.right});
        }

        public String toString() {
            return String.format("%s %s %s", this.left, this.operator.getValue(), this.right);
        }
    }
}

