/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.canon;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class DigestOutputStream
extends FilterOutputStream {
    private final MessageDigest md;

    public DigestOutputStream(MessageDigest md) {
        this(md, null);
    }

    public DigestOutputStream(MessageDigest md, OutputStream out) {
        super(out);
        this.md = md;
    }

    @Override
    public void write(int arg0) throws IOException {
        this.md.update((byte)arg0);
        if (this.out != null) {
            this.out.write(arg0);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.md.update(b, off, len);
        if (this.out != null) {
            this.out.write(b, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            super.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            super.flush();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.md.update(b);
        if (this.out != null) {
            this.out.write(b);
        }
    }

    public byte[] getDigest() {
        return this.md.digest();
    }
}

