/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.dto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaSizeLimit;

@JsonDeserialize(builder=Builder.class)
public class ValidatedQuotaDTO {
    private final Optional<QuotaCountLimit> count;
    private final Optional<QuotaSizeLimit> size;

    public static Builder builder() {
        return new Builder();
    }

    private ValidatedQuotaDTO(Optional<QuotaCountLimit> count, Optional<QuotaSizeLimit> size) {
        this.count = count;
        this.size = size;
    }

    public Optional<QuotaCountLimit> getCount() {
        return this.count;
    }

    public Optional<QuotaSizeLimit> getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (o instanceof ValidatedQuotaDTO) {
            ValidatedQuotaDTO that = (ValidatedQuotaDTO)o;
            return Objects.equals(this.count, that.count) && Objects.equals(this.size, that.size);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.count, this.size);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("count", this.count).add("size", this.size).toString();
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Optional<QuotaCountLimit> count = Optional.empty();
        private Optional<QuotaSizeLimit> size = Optional.empty();

        private Builder() {
        }

        public Builder count(Optional<QuotaCountLimit> count) {
            this.count = count;
            return this;
        }

        public Builder size(Optional<QuotaSizeLimit> size) {
            this.size = size;
            return this;
        }

        public ValidatedQuotaDTO build() {
            return new ValidatedQuotaDTO(this.count, this.size);
        }
    }
}

