/*
 * Decompiled with CFR 0.152.
 */
package feign.form;

import feign.Request;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.form.ContentProcessor;
import feign.form.ContentType;
import feign.form.multipart.ByteArrayWriter;
import feign.form.multipart.DelegateWriter;
import feign.form.multipart.FormDataWriter;
import feign.form.multipart.ManyFilesWriter;
import feign.form.multipart.ManyParametersWriter;
import feign.form.multipart.Output;
import feign.form.multipart.PojoWriter;
import feign.form.multipart.SingleFileWriter;
import feign.form.multipart.SingleParameterWriter;
import feign.form.multipart.Writer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;

public class MultipartFormContentProcessor
implements ContentProcessor {
    private final Deque<Writer> writers = new LinkedList<Writer>();
    private final Writer defaultPerocessor;

    public MultipartFormContentProcessor(Encoder delegate) {
        this.addWriter(new ByteArrayWriter());
        this.addWriter(new FormDataWriter());
        this.addWriter(new SingleFileWriter());
        this.addWriter(new ManyFilesWriter());
        this.addWriter(new SingleParameterWriter());
        this.addWriter(new ManyParametersWriter());
        this.addWriter(new PojoWriter(this.writers));
        this.defaultPerocessor = new DelegateWriter(delegate);
    }

    @Override
    public void process(RequestTemplate template, Charset charset, Map<String, Object> data) throws EncodeException {
        String boundary = Long.toHexString(System.currentTimeMillis());
        Output output = new Output(charset);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            Writer writer = this.findApplicableWriter(entry.getValue());
            writer.write(output, boundary, entry.getKey(), entry.getValue());
        }
        output.write("--").write(boundary).write("--").write("\r\n");
        String contentTypeHeaderValue = this.getSupportedContentType().getHeader() + "; charset=" + charset.name() + "; boundary=" + boundary;
        template.header("Content-Type", Collections.emptyList());
        template.header("Content-Type", new String[]{contentTypeHeaderValue});
        byte[] bytes = output.toByteArray();
        Request.Body body = Request.Body.encoded((byte[])bytes, null);
        template.body(body);
        try {
            output.close();
        }
        catch (IOException ex) {
            throw new EncodeException("Output closing error", (Throwable)ex);
        }
    }

    @Override
    public ContentType getSupportedContentType() {
        return ContentType.MULTIPART;
    }

    public final void addWriter(Writer writer) {
        this.writers.add(writer);
    }

    public final void addFirstWriter(Writer writer) {
        this.writers.addFirst(writer);
    }

    public final void addLastWriter(Writer writer) {
        this.writers.addLast(writer);
    }

    public final Collection<Writer> getWriters() {
        return Collections.unmodifiableCollection(this.writers);
    }

    private Writer findApplicableWriter(Object value) {
        for (Writer writer : this.writers) {
            if (!writer.isApplicable(value)) continue;
            return writer;
        }
        return this.defaultPerocessor;
    }
}

