/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.GregorianCalendar;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSUSERSRowFactory
extends CatalogRowFactory {
    public static final String TABLE_NAME = "SYSUSERS";
    public static final String SYSUSERS_UUID = "9810800c-0134-14a5-40c1-000004f61f90";
    public static final String PASSWORD_COL_NAME = "PASSWORD";
    private static final int SYSUSERS_COLUMN_COUNT = 4;
    public static final int USERNAME_COL_NUM = 1;
    public static final int HASHINGSCHEME_COL_NUM = 2;
    public static final int PASSWORD_COL_NUM = 3;
    public static final int LASTMODIFIED_COL_NUM = 4;
    static final int SYSUSERS_INDEX1_ID = 0;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"9810800c-0134-14a5-40c1-000004f61f90", "9810800c-0134-14a5-a609-000004f61f90", "9810800c-0134-14a5-f1cd-000004f61f90"};

    SYSUSERSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(4, TABLE_NAME, indexColumnPositions, uniqueness, uuids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        ExecRow execRow;
        String string = null;
        String string2 = null;
        char[] cArray = null;
        Timestamp timestamp = null;
        try {
            if (tupleDescriptor != null) {
                UserDescriptor userDescriptor = (UserDescriptor)tupleDescriptor;
                string = userDescriptor.getUserName();
                string2 = userDescriptor.getHashingScheme();
                cArray = userDescriptor.getAndZeroPassword();
                timestamp = userDescriptor.getLastModified();
            }
            execRow = this.getExecutionFactory().getValueRow(4);
            execRow.setColumn(1, new SQLVarchar(string));
            execRow.setColumn(2, new SQLVarchar(string2));
            execRow.setColumn(3, new SQLVarchar(cArray));
            execRow.setColumn(4, new SQLTimestamp(timestamp));
            if (cArray == null) return execRow;
        }
        catch (Throwable throwable) {
            if (cArray == null) throw throwable;
            Arrays.fill(cArray, '\u0000');
            throw throwable;
        }
        Arrays.fill(cArray, '\u0000');
        return execRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        UserDescriptor userDescriptor;
        SQLChar sQLChar;
        block5: {
            DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
            char[] cArray = null;
            sQLChar = null;
            try {
                DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
                String string = dataValueDescriptor.getString();
                dataValueDescriptor = execRow.getColumn(2);
                String string2 = dataValueDescriptor.getString();
                sQLChar = (SQLVarchar)execRow.getColumn(3);
                cArray = sQLChar.getRawDataAndZeroIt();
                dataValueDescriptor = execRow.getColumn(4);
                Timestamp timestamp = dataValueDescriptor.getTimestamp(new GregorianCalendar());
                userDescriptor = dataDescriptorGenerator.newUserDescriptor(string, string2, cArray, timestamp);
                if (cArray == null) break block5;
            }
            catch (Throwable throwable) {
                if (cArray != null) {
                    Arrays.fill(cArray, '\u0000');
                }
                if (sQLChar != null) {
                    sQLChar.zeroRawData();
                }
                throw throwable;
            }
            Arrays.fill(cArray, '\u0000');
        }
        if (sQLChar != null) {
            sQLChar.zeroRawData();
        }
        return userDescriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getIdentifierColumn("USERNAME", false), SystemColumnImpl.getColumn("HASHINGSCHEME", 12, false, 32672), SystemColumnImpl.getColumn(PASSWORD_COL_NAME, 12, false, 32672), SystemColumnImpl.getColumn("LASTMODIFIED", 93, false)};
    }
}

