/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailet.base;

import com.github.fge.lambdas.Throwing;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.james.javax.MultipartUtil;
import org.apache.mailet.MailetContext;

public class Converter7Bit {
    private final MailetContext mailetContext;

    public Converter7Bit(MailetContext mailetContext) {
        this.mailetContext = mailetContext;
    }

    public void convertTo7Bit(MimeMessage mimeMessage) throws MessagingException, IOException {
        this.convertPart(mimeMessage);
        mimeMessage.saveChanges();
    }

    private void convertPart(MimePart part) throws MessagingException, IOException {
        if ("8bit".equals(part.getEncoding())) {
            String contentTransferEncoding = part.isMimeType("text/*") ? "quoted-printable" : "base64";
            part.setContent(part.getContent(), part.getContentType());
            part.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
            part.addHeader("X-MIME-Autoconverted", "from 8bit to " + contentTransferEncoding + " by " + this.mailetContext.getServerInfo());
        } else if (part.isMimeType("multipart/*")) {
            MultipartUtil.retrieveBodyParts((MimeMultipart)part.getContent()).forEach(Throwing.consumer(bodyPart -> this.convertPart((MimePart)((Object)bodyPart))));
        }
    }
}

