/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.data.jmap;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.core.Username;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.jmap.api.filtering.Rules;
import org.apache.james.jmap.api.filtering.impl.EventSourcingFilteringManagement;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregate;
import org.apache.james.jmap.api.filtering.impl.FilteringAggregateId;
import org.apache.james.jmap.api.filtering.impl.RuleSetDefined;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.james.task.Task;
import org.apache.james.task.TaskExecutionDetails;
import org.apache.james.task.TaskType;
import org.apache.james.user.api.UsersRepository;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import scala.Option;
import scala.Some;

public class PopulateFilteringProjectionTask
implements Task {
    static final TaskType TASK_TYPE = TaskType.of((String)"PopulateFilteringProjectionTask");
    private final EventSourcingFilteringManagement.NoReadProjection noReadProjection;
    private final EventSourcingFilteringManagement.ReadProjection readProjection;
    private final UsersRepository usersRepository;
    private final AtomicLong processedUserCount = new AtomicLong(0L);
    private final AtomicLong failedUserCount = new AtomicLong(0L);

    public static TaskDTOModule<PopulateFilteringProjectionTask, PopulateFilteringProjectionTaskDTO> module(EventSourcingFilteringManagement.NoReadProjection noReadProjection, EventSourcingFilteringManagement.ReadProjection readProjection, UsersRepository usersRepository) {
        return (TaskDTOModule)DTOModule.forDomainObject(PopulateFilteringProjectionTask.class).convertToDTO(PopulateFilteringProjectionTaskDTO.class).toDomainObjectConverter(dto -> PopulateFilteringProjectionTask.asTask(noReadProjection, readProjection, usersRepository)).toDTOConverter(PopulateFilteringProjectionTask::asDTO).typeName(TASK_TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    private static PopulateFilteringProjectionTaskDTO asDTO(PopulateFilteringProjectionTask task, String type) {
        return new PopulateFilteringProjectionTaskDTO(type);
    }

    private static PopulateFilteringProjectionTask asTask(EventSourcingFilteringManagement.NoReadProjection noReadProjection, EventSourcingFilteringManagement.ReadProjection readProjection, UsersRepository usersRepository) {
        return new PopulateFilteringProjectionTask(noReadProjection, readProjection, usersRepository);
    }

    public PopulateFilteringProjectionTask(EventSourcingFilteringManagement.NoReadProjection noReadProjection, EventSourcingFilteringManagement.ReadProjection readProjection, UsersRepository usersRepository) {
        this.noReadProjection = noReadProjection;
        this.readProjection = readProjection;
        this.usersRepository = usersRepository;
    }

    public Task.Result run() {
        return (Task.Result)Flux.from((Publisher)this.usersRepository.listReactive()).concatMap(user -> Mono.from((Publisher)this.noReadProjection.listRulesForUser(user)).flatMap(rules -> rules.getVersion().asEventId().flatMap(eventId -> this.readProjection.subscriber(any -> Mono.empty()).map(s -> Mono.from((Publisher)s.handleReactive(this.asEvent((Username)user, (Rules)rules, (EventId)eventId))))).orElse(Mono.empty())).thenReturn((Object)Task.Result.COMPLETED).doOnNext(next -> this.processedUserCount.incrementAndGet()).onErrorResume(e -> {
            LOGGER.error("Failed populating Cassandra filter read projection for {}", user);
            this.failedUserCount.incrementAndGet();
            return Mono.just((Object)Task.Result.PARTIAL);
        })).reduce(Task::combine).switchIfEmpty(Mono.just((Object)Task.Result.COMPLETED)).block();
    }

    private EventWithState asEvent(Username user, Rules rules, EventId eventId) {
        return new EventWithState((Event)new RuleSetDefined(new FilteringAggregateId(user), eventId, ImmutableList.copyOf((Collection)rules.getRules())), (Option)Some.apply((Object)new FilteringAggregate.FilterState(ImmutableList.copyOf((Collection)rules.getRules()))));
    }

    public TaskType type() {
        return TASK_TYPE;
    }

    public Optional<TaskExecutionDetails.AdditionalInformation> details() {
        return Optional.of(AdditionalInformation.from(this.processedUserCount, this.failedUserCount));
    }

    public static class PopulateFilteringProjectionTaskDTO
    implements TaskDTO {
        private final String type;

        public PopulateFilteringProjectionTaskDTO(@JsonProperty(value="type") String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }

    public static class AdditionalInformation
    implements TaskExecutionDetails.AdditionalInformation {
        private final long processedUserCount;
        private final long failedUserCount;
        private final Instant timestamp;

        private static AdditionalInformation from(AtomicLong processedUserCount, AtomicLong failedUserCount) {
            return new AdditionalInformation(processedUserCount.get(), failedUserCount.get(), Clock.systemUTC().instant());
        }

        public AdditionalInformation(long processedUserCount, long failedUserCount, Instant timestamp) {
            this.processedUserCount = processedUserCount;
            this.failedUserCount = failedUserCount;
            this.timestamp = timestamp;
        }

        public long getProcessedUserCount() {
            return this.processedUserCount;
        }

        public long getFailedUserCount() {
            return this.failedUserCount;
        }

        public Instant timestamp() {
            return this.timestamp;
        }
    }
}

