/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public class Port {
    public static final int MAX_PORT_VALUE = 65535;
    public static final int PRIVILEGED_PORT_BOUND = 1024;
    private static final Range<Integer> VALID_PORT_RANGE = Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(65535));
    private final int value;

    public static Port of(int portNumber) {
        return new Port(portNumber);
    }

    public static int generateValidUnprivilegedPort() {
        return ThreadLocalRandom.current().nextInt(64511) + 1024;
    }

    public static void assertValid(int port) {
        Preconditions.checkArgument((boolean)Port.isValid(port), (Object)"Port should be between 1 and 65535");
    }

    public static boolean isValid(int port) {
        return VALID_PORT_RANGE.contains((Comparable)Integer.valueOf(port));
    }

    public Port(int value) {
        this.validate(value);
        this.value = value;
    }

    protected void validate(int port) {
        Port.assertValid(port);
    }

    public int getValue() {
        return this.value;
    }

    public final boolean equals(Object o) {
        if (o instanceof Port) {
            Port indexName = (Port)o;
            return Objects.equals(this.value, indexName.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }
}

