/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.prefs;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MRUFileList {
    private static MRUFileList log4jList = new MRUFileList();
    private static final int DEFAULT_MRU_SIZE = 5;
    private List fileList = new ArrayList();
    private int size = 5;
    private static transient EventListenerList listeners = new EventListenerList();

    private MRUFileList() {
    }

    public static void addChangeListener(ChangeListener listener) {
        listeners.add(ChangeListener.class, listener);
    }

    public static void removeChangeListener(ChangeListener listener) {
        listeners.remove(ChangeListener.class, listener);
    }

    public void opened(URL url) {
        this.fileList.remove(url);
        while (this.fileList.size() >= this.size) {
            this.fileList.remove(this.fileList.size() - 1);
        }
        this.fileList.add(0, url);
        MRUFileList.fireChangeEvent();
    }

    private static void fireChangeEvent() {
        ChangeEvent event = null;
        EventListener[] eventListeners = listeners.getListeners(ChangeListener.class);
        for (int i = 0; i < eventListeners.length; ++i) {
            ChangeListener listener = (ChangeListener)eventListeners[i];
            if (event == null) {
                event = new ChangeEvent(MRUFileList.class);
            }
            listener.stateChanged(event);
        }
    }

    public List getMRUList() {
        return Collections.unmodifiableList(this.fileList);
    }

    public static MRUFileList log4jMRU() {
        return log4jList;
    }

    public static void loadLog4jMRUListFromXML(String xml) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        log4jList = (MRUFileList)xstream.fromXML(xml);
        MRUFileList.fireChangeEvent();
    }

    public static void loadLog4jMRUListFromReader(Reader reader) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        log4jList = (MRUFileList)xstream.fromXML(reader);
        MRUFileList.fireChangeEvent();
    }
}

