/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.LoggerRepositoryExImpl;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.ApplicationPreferenceModelPanel;
import org.apache.log4j.chainsaw.ApplicationPreferenceModelSaver;
import org.apache.log4j.chainsaw.ChainsawAbout;
import org.apache.log4j.chainsaw.ChainsawAppender;
import org.apache.log4j.chainsaw.ChainsawAppenderHandler;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.ChainsawSplash;
import org.apache.log4j.chainsaw.ChainsawStatusBar;
import org.apache.log4j.chainsaw.ChainsawTabbedPane;
import org.apache.log4j.chainsaw.ChainsawToolBarAndMenus;
import org.apache.log4j.chainsaw.ChainsawViewer;
import org.apache.log4j.chainsaw.DockablePanel;
import org.apache.log4j.chainsaw.EventBatchListener;
import org.apache.log4j.chainsaw.EventCountListener;
import org.apache.log4j.chainsaw.FileLoadAction;
import org.apache.log4j.chainsaw.Generator;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.LogFilePatternLayoutBuilder;
import org.apache.log4j.chainsaw.LogPanel;
import org.apache.log4j.chainsaw.LoggingEventWrapper;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.ProgressPanel;
import org.apache.log4j.chainsaw.ReceiverConfigurationPanel;
import org.apache.log4j.chainsaw.ShutdownListener;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.WelcomePanel;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.dnd.FileDnDTarget;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.help.Tutorial;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.osx.OSXIntegration;
import org.apache.log4j.chainsaw.plugins.PluginClassLoaderFactory;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.MRUFileListPreferenceSaver;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.chainsaw.receivers.ReceiversHelper;
import org.apache.log4j.chainsaw.receivers.ReceiversPanel;
import org.apache.log4j.chainsaw.vfs.VFSLogFilePatternReceiver;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.plugins.PluginRegistry;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.rewrite.PropertyRewritePolicy;
import org.apache.log4j.rewrite.RewriteAppender;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.XMLDecoder;

public class LogUI
extends JFrame
implements ChainsawViewer,
SettingsListener {
    private static final String MAIN_WINDOW_HEIGHT = "main.window.height";
    private static final String MAIN_WINDOW_WIDTH = "main.window.width";
    private static final String MAIN_WINDOW_Y = "main.window.y";
    private static final String MAIN_WINDOW_X = "main.window.x";
    private static ChainsawSplash splash;
    private static final double DEFAULT_MAIN_RECEIVER_SPLIT_LOCATION = 0.85;
    private final JFrame preferencesFrame = new JFrame();
    private boolean noReceiversDefined;
    private ReceiversPanel receiversPanel;
    private ChainsawTabbedPane tabbedPane;
    private JToolBar toolbar;
    private ChainsawStatusBar statusBar;
    private ApplicationPreferenceModel applicationPreferenceModel;
    private ApplicationPreferenceModelPanel applicationPreferenceModelPanel;
    private final Map tableModelMap = new HashMap();
    private final Map tableMap = new HashMap();
    private final List<String> filterableColumns = new ArrayList<String>();
    private final Map<String, Component> panelMap = new HashMap<String, Component>();
    ChainsawAppenderHandler handler;
    private ChainsawToolBarAndMenus tbms;
    private ChainsawAbout aboutBox;
    private final SettingsManager sm = SettingsManager.getInstance();
    private final JFrame tutorialFrame = new JFrame("Chainsaw Tutorial");
    private JSplitPane mainReceiverSplitPane;
    private double lastMainReceiverSplitLocation = 0.85;
    private final List<LogPanel> identifierPanels = new ArrayList<LogPanel>();
    private int dividerSize;
    private int cyclicBufferSize;
    private static Logger logger;
    private static String configurationURLAppArg;
    private boolean isGUIFullyInitialized = false;
    private final Object initializationLock = new Object();
    private Action shutdownAction = null;
    private EventListenerList shutdownListenerList = new EventListenerList();
    private WelcomePanel welcomePanel;
    private static final Object repositorySelectorGuard;
    private static final LoggerRepositoryExImpl repositoryExImpl;
    private PluginRegistry pluginRegistry;
    private Map<String, RuleColorizer> allColorizers = new HashMap<String, RuleColorizer>();
    private ReceiverConfigurationPanel receiverConfigurationPanel = new ReceiverConfigurationPanel();

    public LogUI() {
        super("Chainsaw");
        this.setDefaultCloseOperation(0);
        if (ChainsawIcons.WINDOW_ICON != null) {
            this.setIconImage(new ImageIcon(ChainsawIcons.WINDOW_ICON).getImage());
        }
    }

    private static final void showSplash(Frame owner) {
        splash = new ChainsawSplash(owner);
        SwingHelper.centerOnScreen(splash);
        splash.setVisible(true);
    }

    private static final void removeSplash() {
        if (splash != null) {
            splash.setVisible(false);
            splash.dispose();
        }
    }

    public void addShutdownListener(ShutdownListener l) {
        this.shutdownListenerList.add(ShutdownListener.class, l);
    }

    public void removeShutdownListener(ShutdownListener l) {
        this.shutdownListenerList.remove(ShutdownListener.class, l);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configurationURLAppArg = args[0];
        }
        if (OSXIntegration.IS_OSX) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        LogManager.setRepositorySelector(() -> repositoryExImpl, repositorySelectorGuard);
        ApplicationPreferenceModel model = new ApplicationPreferenceModel();
        SettingsManager.getInstance().configure(new ApplicationPreferenceModelSaver(model));
        if (configurationURLAppArg != null) {
            model.setBypassConfigurationURL(configurationURLAppArg);
        }
        EventQueue.invokeLater(() -> {
            String osName;
            String lookAndFeelClassName = model.getLookAndFeelClassName();
            if ((lookAndFeelClassName == null || lookAndFeelClassName.trim().equals("")) && !(osName = System.getProperty("os.name")).toLowerCase(Locale.ENGLISH).startsWith("mac")) {
                if (osName.toLowerCase(Locale.ENGLISH).startsWith("windows")) {
                    lookAndFeelClassName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                    model.setLookAndFeelClassName(lookAndFeelClassName);
                } else if (osName.toLowerCase(Locale.ENGLISH).startsWith("linux")) {
                    lookAndFeelClassName = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                    model.setLookAndFeelClassName(lookAndFeelClassName);
                }
            }
            if (lookAndFeelClassName != null && !lookAndFeelClassName.trim().equals("")) {
                LogUI.loadLookAndFeelUsingPluginClassLoader(lookAndFeelClassName);
            }
            LogUI.createChainsawGUI(model, null);
        });
    }

    public static void createChainsawGUI(ApplicationPreferenceModel model, Action newShutdownAction) {
        Appender nextAppender;
        if (model.isOkToRemoveSecurityManager()) {
            MessageCenter.getInstance().addMessage("User has authorised removal of Java Security Manager via preferences");
            System.setSecurityManager(null);
            Policy.setPolicy(new Policy(){

                @Override
                public void refresh() {
                }

                @Override
                public PermissionCollection getPermissions(CodeSource codesource) {
                    Permissions perms = new Permissions();
                    perms.add(new AllPermission());
                    return perms;
                }
            });
        }
        LogUI logUI = new LogUI();
        logUI.applicationPreferenceModel = model;
        if (model.isShowSplash()) {
            LogUI.showSplash(logUI);
        }
        logUI.cyclicBufferSize = model.getCyclicBufferSize();
        logUI.pluginRegistry = repositoryExImpl.getPluginRegistry();
        ChainsawAppenderHandler chainsawAppenderHandler = logUI.handler = new ChainsawAppenderHandler();
        LogUI logUI2 = logUI;
        Objects.requireNonNull(logUI2);
        chainsawAppenderHandler.addEventBatchListener(logUI2.new NewTabEventBatchReceiver());
        logUI.ensureChainsawAppenderHandlerAdded();
        logger = LogManager.getLogger(LogUI.class);
        PropertyRewritePolicy policy = new PropertyRewritePolicy();
        policy.setProperties("hostname=chainsaw,application=log,group=chainsaw");
        RewriteAppender rewriteAppender = new RewriteAppender();
        rewriteAppender.setRewritePolicy(policy);
        Enumeration appenders = Logger.getLogger("org.apache").getAllAppenders();
        if (!appenders.hasMoreElements()) {
            appenders = Logger.getRootLogger().getAllAppenders();
        }
        while (appenders.hasMoreElements()) {
            nextAppender = (Appender)appenders.nextElement();
            rewriteAppender.addAppender(nextAppender);
        }
        Logger.getLogger("org.apache").removeAllAppenders();
        Logger.getLogger("org.apache").addAppender(rewriteAppender);
        Logger.getLogger("org.apache").setAdditivity(false);
        appenders = Logger.getLogger("httpclient").getAllAppenders();
        if (!appenders.hasMoreElements()) {
            appenders = Logger.getRootLogger().getAllAppenders();
        }
        while (appenders.hasMoreElements()) {
            nextAppender = (Appender)appenders.nextElement();
            rewriteAppender.addAppender(nextAppender);
        }
        Logger.getLogger("httpclient").removeAllAppenders();
        Logger.getLogger("httpclient").addAppender(rewriteAppender);
        Logger.getLogger("httpclient").setAdditivity(false);
        Logger.getLogger("org.apache.commons.vfs.cache").setLevel(Level.INFO);
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            e.printStackTrace();
            logger.error("Uncaught exception in thread " + t, e);
        });
        String config = configurationURLAppArg;
        if (config != null) {
            logger.info("Command-line configuration arg provided (overriding auto-configuration URL) - using: " + config);
        } else {
            config = model.getConfigurationURL();
        }
        if (config != null && !config.trim().equals("")) {
            config = config.trim();
            try {
                URL configURL = new URL(config);
                logger.info("Using '" + config + "' for auto-configuration");
                logUI.loadConfigurationUsingPluginClassLoader(configURL);
            }
            catch (MalformedURLException e2) {
                logger.error("Initial configuration - failed to convert config string to url", e2);
            }
            catch (IOException e3) {
                logger.error("Unable to access auto-configuration URL: " + config);
            }
        }
        model.addPropertyChangeListener("configurationURL", evt -> {
            String newConfiguration = evt.getNewValue().toString();
            if (newConfiguration != null && !newConfiguration.trim().equals("")) {
                newConfiguration = newConfiguration.trim();
                try {
                    logger.info("loading updated configuration: " + newConfiguration);
                    URL newConfigurationURL = new URL(newConfiguration);
                    File file = new File(newConfigurationURL.toURI());
                    if (file.exists()) {
                        logUI.loadConfigurationUsingPluginClassLoader(newConfigurationURL);
                    } else {
                        logger.info("Updated configuration but file does not exist");
                    }
                }
                catch (MalformedURLException | URISyntaxException e) {
                    logger.error("Updated configuration - failed to convert config string to URL", e);
                }
            }
        });
        LogManager.getRootLogger().setLevel(Level.TRACE);
        EventQueue.invokeLater(logUI::activateViewer);
        logger.info("SecurityManager is now: " + System.getSecurityManager());
        if (newShutdownAction != null) {
            logUI.setShutdownAction(newShutdownAction);
        } else {
            logUI.setShutdownAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
    }

    @Override
    public void activateViewer(ChainsawAppender appender) {
        if (OSXIntegration.IS_OSX) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        LogManager.setRepositorySelector(() -> repositoryExImpl, repositorySelectorGuard);
        LogManager.getRootLogger().setLevel(Level.TRACE);
        ApplicationPreferenceModel model = new ApplicationPreferenceModel();
        SettingsManager.getInstance().configure(new ApplicationPreferenceModelSaver(model));
        this.cyclicBufferSize = model.getCyclicBufferSize();
        this.handler = new ChainsawAppenderHandler(appender);
        this.handler.addEventBatchListener(new NewTabEventBatchReceiver());
        logger = LogManager.getLogger(LogUI.class);
        this.setShutdownAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.applicationPreferenceModel = new ApplicationPreferenceModel();
        SettingsManager.getInstance().configure(new ApplicationPreferenceModelSaver(model));
        EventQueue.invokeLater(() -> {
            LogUI.loadLookAndFeelUsingPluginClassLoader(model.getLookAndFeelClassName());
            LogUI.createChainsawGUI(model, null);
            this.getApplicationPreferenceModel().apply(model);
            this.activateViewer();
        });
    }

    private void initGUI() {
        this.setupHelpSystem();
        this.statusBar = new ChainsawStatusBar(this);
        this.setupReceiverPanel();
        this.setToolBarAndMenus(new ChainsawToolBarAndMenus(this));
        this.toolbar = this.getToolBarAndMenus().getToolbar();
        this.setJMenuBar(this.getToolBarAndMenus().getMenubar());
        this.setTabbedPane(new ChainsawTabbedPane());
        this.getSettingsManager().addSettingsListener(this.getTabbedPane());
        this.getSettingsManager().configure(this.getTabbedPane());
        FileDnDTarget dnDTarget = new FileDnDTarget(this.tabbedPane);
        dnDTarget.addPropertyChangeListener("fileList", evt -> {
            List fileList = (List)evt.getNewValue();
            Thread thread = new Thread(() -> {
                logger.debug("Loading files: " + fileList);
                for (Object aFileList : fileList) {
                    File file = (File)aFileList;
                    XMLDecoder decoder = new XMLDecoder();
                    try {
                        this.getStatusBar().setMessage("Loading " + file.getAbsolutePath() + "...");
                        FileLoadAction.importURL(this.handler, decoder, file.getName(), file.toURI().toURL());
                    }
                    catch (Exception e) {
                        String errorMsg = "Failed to import a file";
                        logger.error(errorMsg, e);
                        this.getStatusBar().setMessage(errorMsg);
                    }
                }
            });
            thread.setPriority(1);
            thread.start();
        });
        this.applicationPreferenceModelPanel = new ApplicationPreferenceModelPanel(this.applicationPreferenceModel);
        this.applicationPreferenceModelPanel.setOkCancelActionListener(e -> this.preferencesFrame.setVisible(false));
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogUI.this.preferencesFrame.setVisible(false);
            }
        };
        this.preferencesFrame.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.preferencesFrame.getRootPane().getActionMap().put("ESCAPE", closeAction);
        OSXIntegration.init(this);
    }

    private void initPlugins(PluginRegistry pluginRegistry) {
        pluginRegistry.addPluginListener(new PluginListener(){

            @Override
            public void pluginStarted(PluginEvent e) {
                if (e.getPlugin() instanceof JComponent) {
                    JComponent plugin = (JComponent)((Object)e.getPlugin());
                    LogUI.this.getTabbedPane().addANewTab(plugin.getName(), plugin, null, null);
                    LogUI.this.getPanelMap().put(plugin.getName(), plugin);
                }
            }

            @Override
            public void pluginStopped(PluginEvent e) {
            }
        });
        try {
            Class<Plugin> pluginClass = Class.forName("org.apache.log4j.chainsaw.zeroconf.ZeroConfPlugin").asSubclass(Plugin.class);
            Plugin plugin = pluginClass.newInstance();
            pluginRegistry.addPlugin(plugin);
            plugin.activateOptions();
            MessageCenter.getInstance().getLogger().info("Looks like ZeroConf is available... WooHoo!");
        }
        catch (Throwable e) {
            MessageCenter.getInstance().getLogger().error("Doesn't look like ZeroConf is available", e);
        }
    }

    private void setupReceiverPanel() {
        this.receiversPanel = new ReceiversPanel();
        this.receiversPanel.addPropertyChangeListener("visible", evt -> this.getApplicationPreferenceModel().setReceivers((Boolean)evt.getNewValue()));
    }

    private void setupHelpSystem() {
        this.welcomePanel = new WelcomePanel();
        JToolBar tb = this.welcomePanel.getToolbar();
        tb.add(new SmallButton(new AbstractAction("Tutorial", new ImageIcon(ChainsawIcons.HELP)){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogUI.this.setupTutorial();
            }
        }));
        tb.addSeparator();
        AbstractAction exampleConfigAction = new AbstractAction("View example Receiver configuration"){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpManager.getInstance().setHelpURL(ChainsawConstants.EXAMPLE_CONFIG_URL);
            }
        };
        exampleConfigAction.putValue("ShortDescription", "Displays an example Log4j configuration file with several Receivers defined.");
        SmallButton exampleButton = new SmallButton(exampleConfigAction);
        tb.add(exampleButton);
        tb.add(Box.createHorizontalGlue());
        HelpManager.getInstance().addPropertyChangeListener("helpURL", evt -> {
            URL newURL = (URL)evt.getNewValue();
            if (newURL != null) {
                this.welcomePanel.setURL(newURL);
                this.ensureWelcomePanelVisible();
            }
        });
    }

    private void ensureWelcomePanelVisible() {
        if (!this.getTabbedPane().containsWelcomePanel()) {
            this.addWelcomePanel();
        }
        this.getTabbedPane().setSelectedComponent(this.welcomePanel);
    }

    @Override
    public void loadSettings(LoadSettingsEvent event) {
        this.setLocation(event.asInt(MAIN_WINDOW_X), event.asInt(MAIN_WINDOW_Y));
        int width = event.asInt(MAIN_WINDOW_WIDTH);
        int height = event.asInt(MAIN_WINDOW_HEIGHT);
        if (width == -1 && height == -1) {
            width = Toolkit.getDefaultToolkit().getScreenSize().width;
            height = Toolkit.getDefaultToolkit().getScreenSize().height;
            this.setSize(width, height);
            this.setExtendedState(this.getExtendedState() | 6);
        } else {
            this.setSize(width, height);
        }
        this.getToolBarAndMenus().stateChange();
        RuleColorizer colorizer = new RuleColorizer();
        colorizer.loadColorSettings("Default");
        this.allColorizers.put("Default", colorizer);
        if (event.getSetting("SavedConfig.logFormat") != null) {
            this.receiverConfigurationPanel.getModel().setLogFormat(event.getSetting("SavedConfig.logFormat"));
        }
    }

    @Override
    public void saveSettings(SaveSettingsEvent event) {
        event.saveSetting(MAIN_WINDOW_X, (int)this.getLocation().getX());
        event.saveSetting(MAIN_WINDOW_Y, (int)this.getLocation().getY());
        event.saveSetting(MAIN_WINDOW_WIDTH, this.getWidth());
        event.saveSetting(MAIN_WINDOW_HEIGHT, this.getHeight());
        RuleColorizer colorizer = this.allColorizers.get("Default");
        colorizer.saveColorSettings("Default");
        if (this.receiverConfigurationPanel.getModel().getLogFormat() != null) {
            event.saveSetting("SavedConfig.logFormat", this.receiverConfigurationPanel.getModel().getLogFormat());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateViewer() {
        LoggerRepository repo = LogManager.getLoggerRepository();
        if (repo instanceof LoggerRepositoryEx) {
            this.pluginRegistry = ((LoggerRepositoryEx)repo).getPluginRegistry();
        }
        this.initGUI();
        this.initPrefModelListeners();
        MessageCenter.getInstance().getLogger().addAppender(new AppenderSkeleton(){

            @Override
            protected void append(LoggingEvent event) {
                LogUI.this.getStatusBar().setMessage(event.getMessage().toString());
            }

            @Override
            public void close() {
            }

            @Override
            public boolean requiresLayout() {
                return false;
            }
        });
        this.initSocketConnectionListener();
        if (this.pluginRegistry.getPlugins(Receiver.class).size() == 0) {
            this.noReceiversDefined = true;
        }
        this.getFilterableColumns().add("LEVEL");
        this.getFilterableColumns().add("LOGGER");
        this.getFilterableColumns().add("THREAD");
        this.getFilterableColumns().add("NDC");
        this.getFilterableColumns().add("PROPERTIES");
        this.getFilterableColumns().add("CLASS");
        this.getFilterableColumns().add("METHOD");
        this.getFilterableColumns().add("FILE");
        this.getFilterableColumns().add("None");
        JPanel panePanel = new JPanel();
        panePanel.setLayout(new BorderLayout(2, 2));
        this.getContentPane().setLayout(new BorderLayout());
        this.getTabbedPane().addChangeListener(this.getToolBarAndMenus());
        this.getTabbedPane().addChangeListener(e -> {
            LogPanel thisLogPanel = this.getCurrentLogPanel();
            if (thisLogPanel != null) {
                thisLogPanel.updateStatusBar();
            }
        });
        KeyStroke ksRight = KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke ksLeft = KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        KeyStroke ksGotoLine = KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getTabbedPane().getInputMap(2).put(ksRight, "MoveRight");
        this.getTabbedPane().getInputMap(2).put(ksLeft, "MoveLeft");
        this.getTabbedPane().getInputMap(2).put(ksGotoLine, "GotoLine");
        AbstractAction moveRight = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int temp = LogUI.this.getTabbedPane().getSelectedIndex();
                if (++temp != LogUI.this.getTabbedPane().getTabCount()) {
                    LogUI.this.getTabbedPane().setSelectedTab(temp);
                }
            }
        };
        AbstractAction moveLeft = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int temp = LogUI.this.getTabbedPane().getSelectedIndex();
                if (--temp > -1) {
                    LogUI.this.getTabbedPane().setSelectedTab(temp);
                }
            }
        };
        AbstractAction gotoLine = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String inputLine = JOptionPane.showInputDialog(LogUI.this, "Enter the line number to go:", "Goto Line", -1);
                try {
                    int lineNumber = Integer.parseInt(inputLine);
                    int row = LogUI.this.getCurrentLogPanel().setSelectedEvent(lineNumber);
                    if (row == -1) {
                        JOptionPane.showMessageDialog(LogUI.this, "You have entered an invalid line number", "Error", 0);
                    }
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(LogUI.this, "You have entered an invalid line number", "Error", 0);
                }
            }
        };
        this.getTabbedPane().getActionMap().put("MoveRight", moveRight);
        this.getTabbedPane().getActionMap().put("MoveLeft", moveLeft);
        this.getTabbedPane().getActionMap().put("GotoLine", gotoLine);
        this.getTabbedPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LogPanel logPanel;
                int tabIndex;
                super.mouseClicked(e);
                if (e.getClickCount() > 1 && (e.getModifiers() & 0x10) > 0 && (tabIndex = LogUI.this.getTabbedPane().getSelectedIndex()) != -1 && tabIndex == LogUI.this.getTabbedPane().getSelectedIndex() && (logPanel = LogUI.this.getCurrentLogPanel()) != null) {
                    logPanel.undock();
                }
            }
        });
        panePanel.add(this.getTabbedPane());
        this.addWelcomePanel();
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.mainReceiverSplitPane = new JSplitPane(1, panePanel, this.receiversPanel);
        this.dividerSize = this.mainReceiverSplitPane.getDividerSize();
        this.mainReceiverSplitPane.setDividerLocation(-1);
        this.getContentPane().add((Component)this.mainReceiverSplitPane, "Center");
        this.initPlugins(this.pluginRegistry);
        this.mainReceiverSplitPane.setResizeWeight(1.0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                LogUI.this.exit();
            }
        });
        this.preferencesFrame.setTitle("'Application-wide Preferences");
        this.preferencesFrame.setIconImage(((ImageIcon)ChainsawIcons.ICON_PREFERENCES).getImage());
        this.preferencesFrame.getContentPane().add(this.applicationPreferenceModelPanel);
        this.preferencesFrame.setSize(750, 520);
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.preferencesFrame.setLocation(new Point(screenDimension.width / 2 - this.preferencesFrame.getSize().width / 2, screenDimension.height / 2 - this.preferencesFrame.getSize().height / 2));
        this.pack();
        JPopupMenu tabPopup = new JPopupMenu();
        AbstractAction hideCurrentTabAction = new AbstractAction("Hide"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component selectedComp = LogUI.this.getTabbedPane().getSelectedComponent();
                if (selectedComp instanceof LogPanel) {
                    LogUI.this.displayPanel(LogUI.this.getCurrentLogPanel().getIdentifier(), false);
                    LogUI.this.tbms.stateChange();
                } else {
                    LogUI.this.getTabbedPane().remove(selectedComp);
                }
            }
        };
        AbstractAction hideOtherTabsAction = new AbstractAction("Hide Others"){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component selectedComp = LogUI.this.getTabbedPane().getSelectedComponent();
                String currentName = selectedComp instanceof LogPanel ? LogUI.this.getCurrentLogPanel().getIdentifier() : (selectedComp instanceof WelcomePanel ? "Welcome" : "Zeroconf");
                int count = LogUI.this.getTabbedPane().getTabCount();
                int index = 0;
                for (int i = 0; i < count; ++i) {
                    String name = LogUI.this.getTabbedPane().getTitleAt(index);
                    if (LogUI.this.getPanelMap().keySet().contains(name) && !name.equals(currentName)) {
                        LogUI.this.displayPanel(name, false);
                        LogUI.this.tbms.stateChange();
                        continue;
                    }
                    ++index;
                }
            }
        };
        AbstractAction showHiddenTabsAction = new AbstractAction("Show All Hidden"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Map.Entry o : LogUI.this.getPanels().entrySet()) {
                    Map.Entry entry = o;
                    Boolean docked = (Boolean)entry.getValue();
                    if (!docked.booleanValue()) continue;
                    String identifier = (String)entry.getKey();
                    int count = LogUI.this.getTabbedPane().getTabCount();
                    boolean found = false;
                    for (int i = 0; i < count; ++i) {
                        String name = LogUI.this.getTabbedPane().getTitleAt(i);
                        if (!name.equals(identifier)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    LogUI.this.displayPanel(identifier, true);
                    LogUI.this.tbms.stateChange();
                }
            }
        };
        tabPopup.add(hideCurrentTabAction);
        tabPopup.add(hideOtherTabsAction);
        tabPopup.addSeparator();
        tabPopup.add(showHiddenTabsAction);
        PopupListener tabPopupListener = new PopupListener(tabPopup);
        this.getTabbedPane().addMouseListener(tabPopupListener);
        this.handler.addPropertyChangeListener("dataRate", evt -> {
            double dataRate = (Double)evt.getNewValue();
            this.statusBar.setDataRate(dataRate);
        });
        this.getSettingsManager().addSettingsListener(this);
        this.getSettingsManager().addSettingsListener(MRUFileListPreferenceSaver.getInstance());
        this.getSettingsManager().addSettingsListener(this.receiversPanel);
        try {
            this.getSettingsManager().loadSettings();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.getSettingsManager().addSettingsListener(new ApplicationPreferenceModelSaver(this.applicationPreferenceModel));
        this.setVisible(true);
        if (this.applicationPreferenceModel.isReceivers()) {
            this.showReceiverPanel();
        } else {
            this.hideReceiverPanel();
        }
        LogUI.removeSplash();
        Object e2 = this.initializationLock;
        synchronized (e2) {
            this.isGUIFullyInitialized = true;
            this.initializationLock.notifyAll();
        }
        if (this.noReceiversDefined && this.applicationPreferenceModel.isShowNoReceiverWarning()) {
            SwingHelper.invokeOnEDT(this::showReceiverConfigurationPanel);
        }
        Container container = this.tutorialFrame.getContentPane();
        JEditorPane tutorialArea = new JEditorPane();
        tutorialArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        tutorialArea.setEditable(false);
        container.setLayout(new BorderLayout());
        try {
            tutorialArea.setPage(ChainsawConstants.TUTORIAL_URL);
            JTextComponentFormatter.applySystemFontAndSize(tutorialArea);
            container.add((Component)new JScrollPane(tutorialArea), "Center");
        }
        catch (Exception e3) {
            MessageCenter.getInstance().getLogger().error("Error occurred loading the Tutorial", e3);
        }
        this.tutorialFrame.setIconImage(new ImageIcon(ChainsawIcons.HELP).getImage());
        this.tutorialFrame.setSize(new Dimension(640, 480));
        final AbstractAction startTutorial = new AbstractAction("Start Tutorial", new ImageIcon(ChainsawIcons.ICON_RESUME_RECEIVER)){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(null, "This will start 3 \"Generator\" receivers for use in the Tutorial.  Is that ok?", "Confirm", 0) == 0) {
                    new Thread(new Tutorial()).start();
                    this.putValue("TutorialStarted", Boolean.TRUE);
                } else {
                    this.putValue("TutorialStarted", Boolean.FALSE);
                }
            }
        };
        AbstractAction stopTutorial = new AbstractAction("Stop Tutorial", new ImageIcon(ChainsawIcons.ICON_STOP_RECEIVER)){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(null, "This will stop all of the \"Generator\" receivers used in the Tutorial, but leave any other Receiver untouched.  Is that ok?", "Confirm", 0) == 0) {
                    new Thread(() -> {
                        LoggerRepository repo1 = LogManager.getLoggerRepository();
                        if (repo1 instanceof LoggerRepositoryEx) {
                            PluginRegistry pluginRegistry = ((LoggerRepositoryEx)repo1).getPluginRegistry();
                            List list = pluginRegistry.getPlugins(Generator.class);
                            for (Object aList : list) {
                                Plugin plugin = (Plugin)aList;
                                pluginRegistry.stopPlugin(plugin.getName());
                            }
                        }
                    }).start();
                    this.setEnabled(false);
                    startTutorial.putValue("TutorialStarted", Boolean.FALSE);
                }
            }
        };
        stopTutorial.putValue("ShortDescription", "Removes all of the Tutorials Generator Receivers, leaving all other Receivers untouched");
        startTutorial.putValue("ShortDescription", "Begins the Tutorial, starting up some Generator Receivers so you can see Chainsaw in action");
        stopTutorial.setEnabled(false);
        SmallToggleButton startButton = new SmallToggleButton(startTutorial);
        PropertyChangeListener pcl = evt -> {
            stopTutorial.setEnabled(startTutorial.getValue("TutorialStarted").equals(Boolean.TRUE));
            startButton.setSelected(stopTutorial.isEnabled());
        };
        startTutorial.addPropertyChangeListener(pcl);
        stopTutorial.addPropertyChangeListener(pcl);
        this.pluginRegistry.addPluginListener(new PluginListener(){

            @Override
            public void pluginStarted(PluginEvent e) {
            }

            @Override
            public void pluginStopped(PluginEvent e) {
                List list = LogUI.this.pluginRegistry.getPlugins(Generator.class);
                if (list.size() == 0) {
                    startTutorial.putValue("TutorialStarted", Boolean.FALSE);
                }
            }
        });
        SmallButton stopButton = new SmallButton(stopTutorial);
        JToolBar tutorialToolbar = new JToolBar();
        tutorialToolbar.setFloatable(false);
        tutorialToolbar.add(startButton);
        tutorialToolbar.add(stopButton);
        container.add((Component)tutorialToolbar, "North");
        tutorialArea.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (e.getDescription().equals("StartTutorial")) {
                    startTutorial.actionPerformed(null);
                } else if (e.getDescription().equals("StopTutorial")) {
                    stopTutorial.actionPerformed(null);
                } else {
                    try {
                        tutorialArea.setPage(e.getURL());
                    }
                    catch (IOException e1) {
                        MessageCenter.getInstance().getLogger().error("Failed to change the URL for the Tutorial", e1);
                    }
                }
            }
        });
        if (!this.getTabbedPane().tabSetting.isWelcome()) {
            this.displayPanel("Welcome", false);
        }
        if (!this.getTabbedPane().tabSetting.isZeroconf()) {
            this.displayPanel("Zeroconf", false);
        }
        this.tbms.stateChange();
    }

    private void showReceiverPanel() {
        this.mainReceiverSplitPane.setDividerSize(this.dividerSize);
        this.mainReceiverSplitPane.setDividerLocation(this.lastMainReceiverSplitLocation);
        this.receiversPanel.setVisible(true);
        this.mainReceiverSplitPane.repaint();
    }

    private void hideReceiverPanel() {
        int currentSize = this.mainReceiverSplitPane.getWidth() - this.mainReceiverSplitPane.getDividerSize();
        if (this.mainReceiverSplitPane.getDividerLocation() > -1 && this.mainReceiverSplitPane.getDividerLocation() + 1 != currentSize && this.mainReceiverSplitPane.getDividerLocation() - 1 != 0) {
            this.lastMainReceiverSplitLocation = (double)this.mainReceiverSplitPane.getDividerLocation() / (double)currentSize;
        }
        this.mainReceiverSplitPane.setDividerSize(0);
        this.receiversPanel.setVisible(false);
        this.mainReceiverSplitPane.repaint();
    }

    private void initSocketConnectionListener() {
        final SocketNodeEventListener socketListener = new SocketNodeEventListener(){

            @Override
            public void socketOpened(String remoteInfo) {
                LogUI.this.statusBar.remoteConnectionReceived(remoteInfo);
            }

            @Override
            public void socketClosedEvent(Exception e) {
                MessageCenter.getInstance().getLogger().info("Connection lost! :: " + e.getMessage());
            }
        };
        PluginListener pluginListener = new PluginListener(){

            @Override
            public void pluginStarted(PluginEvent e) {
                MessageCenter.getInstance().getLogger().info(e.getPlugin().getName() + " started!");
                Method method = this.getAddListenerMethod(e.getPlugin());
                if (method != null) {
                    try {
                        method.invoke((Object)e.getPlugin(), socketListener);
                    }
                    catch (Exception ex) {
                        MessageCenter.getInstance().getLogger().error("Failed to add a SocketNodeEventListener", ex);
                    }
                }
            }

            Method getRemoveListenerMethod(Plugin p) {
                try {
                    return p.getClass().getMethod("removeSocketNodeEventListener", SocketNodeEventListener.class);
                }
                catch (Exception e) {
                    return null;
                }
            }

            Method getAddListenerMethod(Plugin p) {
                try {
                    return p.getClass().getMethod("addSocketNodeEventListener", SocketNodeEventListener.class);
                }
                catch (Exception e) {
                    return null;
                }
            }

            @Override
            public void pluginStopped(PluginEvent e) {
                Method method = this.getRemoveListenerMethod(e.getPlugin());
                if (method != null) {
                    try {
                        method.invoke((Object)e.getPlugin(), socketListener);
                    }
                    catch (Exception ex) {
                        MessageCenter.getInstance().getLogger().error("Failed to remove SocketNodeEventListener", ex);
                    }
                }
                MessageCenter.getInstance().getLogger().info(e.getPlugin().getName() + " stopped!");
            }
        };
        this.pluginRegistry.addPluginListener(pluginListener);
    }

    private void initPrefModelListeners() {
        this.applicationPreferenceModel.addPropertyChangeListener("identifierExpression", evt -> this.handler.setIdentifierExpression(evt.getNewValue().toString()));
        this.handler.setIdentifierExpression(this.applicationPreferenceModel.getIdentifierExpression());
        this.applicationPreferenceModel.addPropertyChangeListener("toolTipDisplayMillis", evt -> ToolTipManager.sharedInstance().setDismissDelay((Integer)evt.getNewValue()));
        ToolTipManager.sharedInstance().setDismissDelay(this.applicationPreferenceModel.getToolTipDisplayMillis());
        this.applicationPreferenceModel.addPropertyChangeListener("responsiveness", evt -> {
            int value = (Integer)evt.getNewValue();
            this.handler.setQueueInterval(value * 1000 - 750);
        });
        this.handler.setQueueInterval(this.applicationPreferenceModel.getResponsiveness() * 1000 - 750);
        this.applicationPreferenceModel.addPropertyChangeListener("tabPlacement", evt -> SwingUtilities.invokeLater(() -> {
            int placement = (Integer)evt.getNewValue();
            switch (placement) {
                case 1: 
                case 3: {
                    this.tabbedPane.setTabPlacement(placement);
                    break;
                }
            }
        }));
        this.applicationPreferenceModel.addPropertyChangeListener("statusBar", evt -> {
            boolean value = (Boolean)evt.getNewValue();
            this.setStatusBarVisible(value);
        });
        this.setStatusBarVisible(this.applicationPreferenceModel.isStatusBar());
        this.applicationPreferenceModel.addPropertyChangeListener("receivers", evt -> {
            boolean value = (Boolean)evt.getNewValue();
            if (value) {
                this.showReceiverPanel();
            } else {
                this.hideReceiverPanel();
            }
        });
        this.applicationPreferenceModel.addPropertyChangeListener("toolbar", evt -> {
            boolean value = (Boolean)evt.getNewValue();
            this.toolbar.setVisible(value);
        });
        this.toolbar.setVisible(this.applicationPreferenceModel.isToolbar());
    }

    private void showReceiverConfigurationPanel() {
        SwingUtilities.invokeLater(() -> {
            JDialog dialog = new JDialog((Frame)this, true);
            dialog.setTitle("Load events into Chainsaw");
            dialog.setDefaultCloseOperation(0);
            dialog.setResizable(false);
            this.receiverConfigurationPanel.setCompletionActionListener(e -> {
                File saveConfigFile;
                dialog.setVisible(false);
                if (this.receiverConfigurationPanel.getModel().isCancelled()) {
                    return;
                }
                this.applicationPreferenceModel.setShowNoReceiverWarning(!this.receiverConfigurationPanel.isDontWarnMeAgain());
                List<Plugin> plugins = this.pluginRegistry.getPlugins();
                for (Plugin plugin1 : plugins) {
                    Plugin plugin = plugin1;
                    if (plugin.getName().toLowerCase(Locale.ENGLISH).contains("zeroconf")) continue;
                    this.pluginRegistry.stopPlugin(plugin.getName());
                }
                URL configURL = null;
                if (this.receiverConfigurationPanel.getModel().isNetworkReceiverMode()) {
                    int port = this.receiverConfigurationPanel.getModel().getNetworkReceiverPort();
                    try {
                        Class<? extends Receiver> receiverClass = this.receiverConfigurationPanel.getModel().getNetworkReceiverClass();
                        Receiver networkReceiver = receiverClass.newInstance();
                        networkReceiver.setName(receiverClass.getSimpleName() + "-" + port);
                        Method portMethod = networkReceiver.getClass().getMethod("setPort", Integer.TYPE);
                        portMethod.invoke((Object)networkReceiver, port);
                        networkReceiver.setThreshold(Level.TRACE);
                        this.pluginRegistry.addPlugin(networkReceiver);
                        networkReceiver.activateOptions();
                        this.receiversPanel.updateReceiverTreeInDispatchThread();
                    }
                    catch (Exception e3) {
                        MessageCenter.getInstance().getLogger().error("Error creating Receiver", e3);
                        MessageCenter.getInstance().getLogger().info("An error occurred creating your Receiver");
                    }
                } else if (this.receiverConfigurationPanel.getModel().isLog4jConfig()) {
                    File log4jConfigFile = this.receiverConfigurationPanel.getModel().getLog4jConfigFile();
                    if (log4jConfigFile != null) {
                        try {
                            Map<String, Map<String, String>> entries = LogFilePatternLayoutBuilder.getAppenderConfiguration(log4jConfigFile);
                            for (Map.Entry<String, Map<String, String>> o : entries.entrySet()) {
                                try {
                                    Map.Entry<String, Map<String, String>> entry = o;
                                    String name = entry.getKey();
                                    Map<String, String> values = entry.getValue();
                                    String conversionPattern = values.get("conversion").toString();
                                    File file = new File(values.get("file").toString());
                                    URL fileURL = file.toURI().toURL();
                                    String timestampFormat = LogFilePatternLayoutBuilder.getTimeStampFormat(conversionPattern);
                                    String receiverPattern = LogFilePatternLayoutBuilder.getLogFormatFromPatternLayout(conversionPattern);
                                    VFSLogFilePatternReceiver fileReceiver = new VFSLogFilePatternReceiver();
                                    fileReceiver.setName(name);
                                    fileReceiver.setAutoReconnect(true);
                                    fileReceiver.setContainer(this);
                                    fileReceiver.setAppendNonMatches(true);
                                    fileReceiver.setFileURL(fileURL.toURI().toString());
                                    fileReceiver.setTailing(true);
                                    fileReceiver.setLogFormat(receiverPattern);
                                    fileReceiver.setTimestampFormat(timestampFormat);
                                    fileReceiver.setThreshold(Level.TRACE);
                                    this.pluginRegistry.addPlugin(fileReceiver);
                                    fileReceiver.activateOptions();
                                    this.receiversPanel.updateReceiverTreeInDispatchThread();
                                }
                                catch (URISyntaxException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                } else if (this.receiverConfigurationPanel.getModel().isLoadConfig()) {
                    configURL = this.receiverConfigurationPanel.getModel().getConfigToLoad();
                } else if (this.receiverConfigurationPanel.getModel().isLogFileReceiverConfig()) {
                    try {
                        URL fileURL = this.receiverConfigurationPanel.getModel().getLogFileURL();
                        if (fileURL != null) {
                            VFSLogFilePatternReceiver fileReceiver = new VFSLogFilePatternReceiver();
                            fileReceiver.setName(fileURL.getFile());
                            fileReceiver.setAutoReconnect(true);
                            fileReceiver.setContainer(this);
                            fileReceiver.setAppendNonMatches(true);
                            fileReceiver.setFileURL(fileURL.toURI().toString());
                            fileReceiver.setTailing(true);
                            if (this.receiverConfigurationPanel.getModel().isPatternLayoutLogFormat()) {
                                fileReceiver.setLogFormat(LogFilePatternLayoutBuilder.getLogFormatFromPatternLayout(this.receiverConfigurationPanel.getModel().getLogFormat()));
                            } else {
                                fileReceiver.setLogFormat(this.receiverConfigurationPanel.getModel().getLogFormat());
                            }
                            fileReceiver.setTimestampFormat(this.receiverConfigurationPanel.getModel().getLogFormatTimestampFormat());
                            fileReceiver.setThreshold(Level.TRACE);
                            this.pluginRegistry.addPlugin(fileReceiver);
                            fileReceiver.activateOptions();
                            this.receiversPanel.updateReceiverTreeInDispatchThread();
                        }
                    }
                    catch (Exception e2) {
                        MessageCenter.getInstance().getLogger().error("Error creating Receiver", e2);
                        MessageCenter.getInstance().getLogger().info("An error occurred creating your Receiver");
                    }
                }
                if (configURL == null && this.receiverConfigurationPanel.isDontWarnMeAgain()) {
                    if (this.receiverConfigurationPanel.getModel().getSaveConfigFile() != null) {
                        try {
                            configURL = this.receiverConfigurationPanel.getModel().getSaveConfigFile().toURI().toURL();
                        }
                        catch (MalformedURLException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        configURL = this.receiverConfigurationPanel.getModel().getDefaultConfigFileURL();
                    }
                }
                if (configURL != null) {
                    MessageCenter.getInstance().getLogger().debug("Initialiazing Log4j with " + configURL.toExternalForm());
                    URL finalURL = configURL;
                    new Thread(() -> {
                        if (this.receiverConfigurationPanel.isDontWarnMeAgain()) {
                            this.applicationPreferenceModel.setConfigurationURL(finalURL.toExternalForm());
                        } else {
                            try {
                                if (new File(finalURL.toURI()).exists()) {
                                    this.loadConfigurationUsingPluginClassLoader(finalURL);
                                }
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                // empty catch block
                            }
                        }
                        this.receiversPanel.updateReceiverTreeInDispatchThread();
                    }).start();
                }
                if ((saveConfigFile = this.receiverConfigurationPanel.getModel().getSaveConfigFile()) != null) {
                    ReceiversHelper.getInstance().saveReceiverConfiguration(saveConfigFile);
                }
            });
            this.receiverConfigurationPanel.setDialog(dialog);
            dialog.getContentPane().add(this.receiverConfigurationPanel);
            dialog.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            dialog.setLocation(screenSize.width / 2 - dialog.getWidth() / 2, screenSize.height / 2 - dialog.getHeight() / 2);
            dialog.setVisible(true);
        });
    }

    public boolean exit() {
        this.getSettingsManager().saveSettings();
        return this.shutdown();
    }

    void addWelcomePanel() {
        this.getTabbedPane().insertTab("Welcome", new ImageIcon(ChainsawIcons.ABOUT), this.welcomePanel, "Welcome/Help", 0);
        this.getTabbedPane().setSelectedComponent(this.welcomePanel);
        this.getPanelMap().put("Welcome", this.welcomePanel);
    }

    void removeWelcomePanel() {
        EventQueue.invokeLater(() -> {
            if (this.getTabbedPane().containsWelcomePanel()) {
                this.getTabbedPane().remove(this.getTabbedPane().getComponentAt(this.getTabbedPane().indexOfTab("Welcome")));
            }
        });
    }

    ChainsawStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void showApplicationPreferences() {
        this.applicationPreferenceModelPanel.updateModel();
        this.preferencesFrame.setVisible(true);
    }

    public void showReceiverConfiguration() {
        this.showReceiverConfigurationPanel();
    }

    public void showAboutBox() {
        if (this.aboutBox == null) {
            this.aboutBox = new ChainsawAbout(this);
        }
        this.aboutBox.setVisible(true);
    }

    Map getPanels() {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        Set<Map.Entry<String, Component>> panelSet = this.getPanelMap().entrySet();
        for (Map.Entry<String, Component> aPanelSet : panelSet) {
            Map.Entry<String, Component> entry = aPanelSet;
            Component o = entry.getValue();
            boolean valueToSend = !(o instanceof LogPanel) || ((DockablePanel)entry.getValue()).isDocked();
            m.put(entry.getKey(), valueToSend);
        }
        return m;
    }

    void displayPanel(String panelName, boolean display) {
        Component p = this.getPanelMap().get(panelName);
        int index = this.getTabbedPane().indexOfTab(panelName);
        if (index == -1 && display) {
            this.getTabbedPane().addTab(panelName, p);
        }
        if (index > -1 && !display) {
            this.getTabbedPane().removeTabAt(index);
        }
    }

    public boolean shutdown() {
        if (this.getApplicationPreferenceModel().isConfirmExit() && JOptionPane.showConfirmDialog(this, "Are you sure you want to exit Chainsaw?", "Confirm Exit", 0, 1) != 0) {
            return false;
        }
        JWindow progressWindow = new JWindow();
        ProgressPanel panel = new ProgressPanel(1, 3, "Shutting down");
        progressWindow.getContentPane().add(panel);
        progressWindow.pack();
        Point p = new Point(this.getLocation());
        p.move((int)this.getSize().getWidth() >> 1, (int)this.getSize().getHeight() >> 1);
        progressWindow.setLocation(p);
        progressWindow.setVisible(true);
        Runnable runnable = () -> {
            try {
                int progress = 1;
                int delay = 25;
                this.handler.close();
                panel.setProgress(progress++);
                Thread.sleep(25L);
                this.pluginRegistry.stopAllPlugins();
                panel.setProgress(progress++);
                Thread.sleep(25L);
                panel.setProgress(progress++);
                Thread.sleep(25L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.fireShutdownEvent();
            this.performShutdownAction();
            progressWindow.setVisible(false);
        };
        if (OSXIntegration.IS_OSX) {
            runnable.run();
        } else {
            new Thread(runnable).start();
        }
        return true;
    }

    private void fireShutdownEvent() {
        ShutdownListener[] listeners;
        for (ShutdownListener listener : listeners = (ShutdownListener[])this.shutdownListenerList.getListeners(ShutdownListener.class)) {
            listener.shuttingDown();
        }
    }

    public final void setShutdownAction(Action shutdownAction) {
        this.shutdownAction = shutdownAction;
    }

    private void performShutdownAction() {
        MessageCenter.getInstance().getLogger().debug("Calling the shutdown Action. Goodbye!");
        this.shutdownAction.actionPerformed(new ActionEvent(this, 1001, "Shutting Down"));
    }

    LogPanel getCurrentLogPanel() {
        Component selectedTab = this.getTabbedPane().getSelectedComponent();
        if (selectedTab instanceof LogPanel) {
            return (LogPanel)selectedTab;
        }
        return null;
    }

    private void setStatusBarVisible(boolean visible) {
        MessageCenter.getInstance().getLogger().debug("Setting StatusBar to " + visible);
        SwingUtilities.invokeLater(() -> this.statusBar.setVisible(visible));
    }

    boolean isStatusBarVisible() {
        return this.statusBar.isVisible();
    }

    public String getActiveTabName() {
        int index = this.getTabbedPane().getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.getTabbedPane().getTitleAt(index);
    }

    public void showHelp(URL url) {
        this.ensureWelcomePanelVisible();
        this.getWelcomePanel().setURL(url);
    }

    private WelcomePanel getWelcomePanel() {
        return this.welcomePanel;
    }

    public boolean isLogTreePanelVisible() {
        return this.getCurrentLogPanel() != null && this.getCurrentLogPanel().isLogTreeVisible();
    }

    public Map<String, Component> getPanelMap() {
        return this.panelMap;
    }

    public SettingsManager getSettingsManager() {
        return this.sm;
    }

    public List<String> getFilterableColumns() {
        return this.filterableColumns;
    }

    public void setToolBarAndMenus(ChainsawToolBarAndMenus tbms) {
        this.tbms = tbms;
    }

    public ChainsawToolBarAndMenus getToolBarAndMenus() {
        return this.tbms;
    }

    public Map getTableMap() {
        return this.tableMap;
    }

    public Map getTableModelMap() {
        return this.tableModelMap;
    }

    public void setTabbedPane(ChainsawTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    public ChainsawTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public final ApplicationPreferenceModel getApplicationPreferenceModel() {
        return this.applicationPreferenceModel;
    }

    public void setupTutorial() {
        SwingUtilities.invokeLater(() -> {
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(0, this.getLocation().y);
            double chainsawwidth = 0.7;
            double tutorialwidth = 1.0 - chainsawwidth;
            this.setSize((int)((double)screen.width * chainsawwidth), this.getSize().height);
            this.invalidate();
            this.validate();
            Dimension size = this.getSize();
            Point loc = this.getLocation();
            this.tutorialFrame.setSize((int)((double)screen.width * tutorialwidth), size.height);
            this.tutorialFrame.setLocation(loc.x + size.width, loc.y);
            this.tutorialFrame.setVisible(true);
        });
    }

    private void buildLogPanel(boolean customExpression, String ident, List<LoggingEvent> events) throws IllegalArgumentException {
        LogPanel thisPanel = new LogPanel(this.getStatusBar(), ident, this.cyclicBufferSize, this.allColorizers, this.applicationPreferenceModel);
        this.getSettingsManager().addSettingsListener(thisPanel);
        this.getSettingsManager().configure(thisPanel);
        if (customExpression) {
            this.handler.addCustomEventBatchListener(ident, thisPanel);
        } else {
            this.identifierPanels.add(thisPanel);
            this.handler.addEventBatchListener(thisPanel);
        }
        TabIconHandler iconHandler = new TabIconHandler(ident);
        thisPanel.addEventCountListener(iconHandler);
        this.tabbedPane.addChangeListener(iconHandler);
        PropertyChangeListener toolbarMenuUpdateListener = evt -> this.tbms.stateChange();
        thisPanel.addPropertyChangeListener(toolbarMenuUpdateListener);
        thisPanel.addPreferencePropertyChangeListener(toolbarMenuUpdateListener);
        thisPanel.addPropertyChangeListener("docked", evt -> {
            LogPanel logPanel = (LogPanel)evt.getSource();
            if (logPanel.isDocked()) {
                this.getPanelMap().put(logPanel.getIdentifier(), logPanel);
                this.getTabbedPane().addANewTab(logPanel.getIdentifier(), logPanel, null);
                this.getTabbedPane().setSelectedTab(this.getTabbedPane().indexOfTab(logPanel.getIdentifier()));
            } else {
                this.getTabbedPane().remove(logPanel);
            }
        });
        logger.debug("adding logpanel to tabbed pane: " + ident);
        this.getTabbedPane().add(ident, thisPanel);
        this.getPanelMap().put(ident, thisPanel);
        SwingUtilities.invokeLater(() -> {
            this.getTabbedPane().addANewTab(ident, thisPanel, new ImageIcon(ChainsawIcons.ANIM_RADIO_TOWER));
            thisPanel.layoutComponents();
            thisPanel.receiveEventBatch(ident, events);
            if (!this.getTabbedPane().tabSetting.isChainsawLog()) {
                this.displayPanel("chainsaw-log", false);
            }
        });
        String msg = "added tab " + ident;
        MessageCenter.getInstance().getLogger().debug(msg);
    }

    public void createCustomExpressionLogPanel(String ident) {
        try {
            ArrayList<LoggingEvent> list = new ArrayList<LoggingEvent>();
            Rule rule = ExpressionRule.getRule(ident);
            Iterator<LogPanel> iterator = this.identifierPanels.iterator();
            while (iterator.hasNext()) {
                LogPanel identifierPanel;
                LogPanel panel = identifierPanel = iterator.next();
                Iterator<LoggingEventWrapper> iterator2 = panel.getMatchingEvents(rule).iterator();
                while (iterator2.hasNext()) {
                    LoggingEventWrapper o;
                    LoggingEventWrapper e = o = iterator2.next();
                    list.add(e.getLoggingEvent());
                }
            }
            this.buildLogPanel(true, ident, list);
        }
        catch (IllegalArgumentException iae) {
            MessageCenter.getInstance().getLogger().info("Unable to add tab using expression: " + ident + ", reason: " + iae.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigurationUsingPluginClassLoader(URL url) {
        ClassLoader classLoader = PluginClassLoaderFactory.getInstance().getClassLoader();
        ClassLoader previousTCCL = Thread.currentThread().getContextClassLoader();
        if (url != null) {
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    DOMConfigurator.configure(url);
                }
                catch (Exception e) {
                    logger.warn("Unable to load configuration URL: " + url, e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousTCCL);
            }
        }
        this.ensureChainsawAppenderHandlerAdded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLookAndFeelUsingPluginClassLoader(String lookAndFeelClassName) {
        ClassLoader classLoader = PluginClassLoaderFactory.getInstance().getClassLoader();
        ClassLoader previousTCCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            UIManager.setLookAndFeel(lookAndFeelClassName);
            UIManager.getLookAndFeelDefaults().put("ClassLoader", classLoader);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(previousTCCL);
        }
    }

    private void ensureChainsawAppenderHandlerAdded() {
        if (!LogManager.getLoggerRepository().getRootLogger().isAttached(this.handler)) {
            LogManager.getLoggerRepository().getRootLogger().addAppender(this.handler);
        }
    }

    static {
        repositorySelectorGuard = new Object();
        repositoryExImpl = new LoggerRepositoryExImpl(LogManager.getLoggerRepository());
    }

    private class TabIconHandler
    implements EventCountListener,
    ChangeListener {
        private boolean newEvents = true;
        private boolean seenEvents = false;
        private final String ident;
        ImageIcon NEW_EVENTS = new ImageIcon(ChainsawIcons.ANIM_RADIO_TOWER);
        ImageIcon HAS_EVENTS = new ImageIcon(ChainsawIcons.INFO);
        Icon SELECTED = LineIconFactory.createBlankIcon();

        public TabIconHandler(String identifier) {
            this.ident = identifier;
            new Thread(() -> {
                while (true) {
                    if (LogUI.this.getTabbedPane().indexOfTab(this.ident) > -1 && LogUI.this.getTabbedPane().getSelectedIndex() == LogUI.this.getTabbedPane().indexOfTab(this.ident)) {
                        LogUI.this.getTabbedPane().setIconAt(LogUI.this.getTabbedPane().indexOfTab(this.ident), this.SELECTED);
                        this.newEvents = false;
                        this.seenEvents = true;
                    } else if (LogUI.this.getTabbedPane().indexOfTab(this.ident) > -1) {
                        if (this.newEvents) {
                            LogUI.this.getTabbedPane().setIconAt(LogUI.this.getTabbedPane().indexOfTab(this.ident), this.NEW_EVENTS);
                            this.newEvents = false;
                            this.seenEvents = false;
                        } else if (!this.seenEvents) {
                            LogUI.this.getTabbedPane().setIconAt(LogUI.this.getTabbedPane().indexOfTab(this.ident), this.HAS_EVENTS);
                        }
                    }
                    try {
                        Thread.sleep(LogUI.this.handler.getQueueInterval() + 1000);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }).start();
        }

        @Override
        public void eventCountChanged(int currentCount, int totalCount) {
            this.newEvents = true;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            if (LogUI.this.getTabbedPane().indexOfTab(this.ident) > -1 && LogUI.this.getTabbedPane().indexOfTab(this.ident) == LogUI.this.getTabbedPane().getSelectedIndex()) {
                LogUI.this.getTabbedPane().setIconAt(LogUI.this.getTabbedPane().indexOfTab(this.ident), this.SELECTED);
            }
        }
    }

    private class NewTabEventBatchReceiver
    implements EventBatchListener {
        private NewTabEventBatchReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveEventBatch(String ident, List<LoggingEvent> events) {
            if (events.size() == 0) {
                return;
            }
            if (!LogUI.this.isGUIFullyInitialized) {
                Object object = LogUI.this.initializationLock;
                synchronized (object) {
                    while (!LogUI.this.isGUIFullyInitialized) {
                        System.out.println("Wanting to add a row, but GUI not initialized, waiting...");
                        try {
                            LogUI.this.initializationLock.wait(1000L);
                            logger.debug("waiting for initialization to complete");
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    logger.debug("out of system initialization wait loop");
                }
            }
            if (!LogUI.this.getPanelMap().containsKey(ident)) {
                logger.debug("panel " + ident + " does not exist - creating");
                try {
                    LogUI.this.buildLogPanel(false, ident, events);
                }
                catch (IllegalArgumentException iae) {
                    logger.error("error creating log panel", iae);
                }
            }
        }

        @Override
        public String getInterestedIdentifier() {
            return null;
        }
    }
}

